/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MoveElementsOperation;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_renameElementProgress;
    }

    @Override
    protected boolean isRename() {
        return true;
    }

    @Override
    protected IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList == null || this.renamingsList.length == 0) {
            return new JavaModelStatus(982);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(IJavaScriptElement element) throws JavaScriptModelException {
        int elementType;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if ((elementType = element.getElementType()) < 7 || elementType == 10) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

