/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.mpi;

import java.util.ArrayList;
import java.util.Collection;

public class CollectiveOperationIdentifiers {
    private static final int UNDEFINED_ROOT_ID = -1;
    private final int fOperationCode;
    private final int fCommunicator;
    private final long fRootLocationId;
    private final Collection<Long> fPendingLocations;
    private final Collection<Long> fEnterTimestamps;

    public CollectiveOperationIdentifiers(int operationCode, int communicator, long rootLocationId, Collection<Long> pendingLocations) {
        this.fOperationCode = operationCode;
        this.fCommunicator = communicator;
        this.fRootLocationId = rootLocationId;
        this.fPendingLocations = pendingLocations;
        this.fEnterTimestamps = new ArrayList<Long>();
    }

    public CollectiveOperationIdentifiers(int operationCode, int communicator, Collection<Long> pendingLocations) {
        this(operationCode, communicator, -1L, pendingLocations);
    }

    public boolean isAssociatedOperation(int operationCode, long rootLocationId, int communicator, long srcLocationId) {
        return operationCode == this.fOperationCode && rootLocationId == this.fRootLocationId && communicator == this.fCommunicator && this.fPendingLocations.contains(srcLocationId);
    }

    public boolean isAssociatedOperation(int operationCode, int communicator, long srcLocationId) {
        return this.isAssociatedOperation(operationCode, -1L, communicator, srcLocationId);
    }

    public boolean isOperationDone() {
        return this.fPendingLocations.isEmpty();
    }

    public void locationCalledOperation(long locationId, long timestamp) {
        this.fPendingLocations.remove(locationId);
        this.fEnterTimestamps.add(timestamp);
    }

    public Collection<Long> getEnterTimestamps() {
        return this.fEnterTimestamps;
    }
}

