/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.callstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.IOtf2Constants;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.AllToRootIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.CollectiveOperationIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.MessageIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.RootToAllIdentifiers;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CallStackStateProvider
extends AbstractOtf2StateProvider {
    private static final String ID = "org.eclipse.tracecompass.incubator.otf2.callstackstateprovider";
    public static final String PROCESSES = "Processes";
    private final Map<Integer, Integer> fLocationGroupStringId = new HashMap<Integer, Integer>();
    private final Map<Long, Location> fMapLocation;
    private final Map<MessageIdentifiers, ITmfEvent> fMsgDataEvent = new HashMap<MessageIdentifiers, ITmfEvent>();
    private final LinkedList<RootToAllIdentifiers> fRootToAllQueue;
    private final LinkedList<AllToRootIdentifiers> fAllToRootQueue;
    private boolean fAllDefinitionsRead = false;

    public Otf2CallStackStateProvider(@Nullable ITmfTrace trace) {
        super(trace, ID);
        this.fMapLocation = new HashMap<Long, Location>();
        this.fRootToAllQueue = new LinkedList();
        this.fAllToRootQueue = new LinkedList();
    }

    public int getVersion() {
        return 1;
    }

    @Override
    public ITmfStateProvider getNewInstance() {
        return new Otf2CallStackStateProvider(this.getTrace());
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                this.processLocationDefinition(event);
                break;
            }
            case "LocationGroup": {
                this.processLocationGroupDefinition(event);
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processLocationDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long locationReference = (Long)content.getFieldValue(Long.class, new String[]{"self"});
        Integer locationGroupReference = (Integer)content.getFieldValue(Integer.class, new String[]{"locationGroup"});
        Integer stringReference = (Integer)content.getFieldValue(Integer.class, new String[]{"name"});
        if (locationReference == null || locationGroupReference == null || stringReference == null) {
            return;
        }
        this.fMapLocation.put(locationReference, new Location(locationReference, stringReference, locationGroupReference));
    }

    private void processLocationGroupDefinition(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Integer locationGroupReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        Integer stringReference = (Integer)content.getFieldValue(Integer.class, new String[]{"name"});
        if (locationGroupReference == null || stringReference == null) {
            return;
        }
        this.fLocationGroupStringId.put(locationGroupReference, stringReference);
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        long locationId;
        Location location;
        if (!this.fAllDefinitionsRead) {
            this.initializeQuarks(ssb);
            this.fAllDefinitionsRead = true;
        }
        if ((location = this.fMapLocation.get(locationId = Otf2CallStackStateProvider.getLocationId(event))) == null) {
            return;
        }
        switch (name) {
            case "Enter": {
                location.enter(event, ssb);
                break;
            }
            case "Leave": {
                location.leave(event, ssb);
                break;
            }
            case "MpiSend": 
            case "MpiIsend": {
                location.mpiSend(event);
                break;
            }
            case "MpiRecv": 
            case "MpiIrecv": {
                location.mpiRecv(event, ssb);
                break;
            }
            case "MpiCollectiveBegin": {
                location.mpiCollectiveBegin(event);
                break;
            }
            case "MpiCollectiveEnd": {
                Otf2CallStackStateProvider.processMpiCollectiveEnd(event, ssb, location);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void initializeQuarks(ITmfStateSystemBuilder ssb) {
        for (Location location : this.fMapLocation.values()) {
            location.initializeQuarks(ssb);
        }
    }

    protected long getLocationIdFromRank(Integer rank, Integer communicatorReference) {
        ArrayList<Long> members = this.getMembersFromCommunicatorReference(communicatorReference);
        if (rank >= members.size()) {
            return -1L;
        }
        return members.get(rank);
    }

    private static void processMpiCollectiveEnd(ITmfEvent event, ITmfStateSystemBuilder ssb, Location location) {
        ITmfEventField content = event.getContent();
        Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
        if (operationCode == null) {
            return;
        }
        switch (IOtf2Constants.getOperation(operationCode)) {
            case BCAST: 
            case SCATTER: 
            case SCATTERV: {
                location.mpiRootToAll(event, ssb);
                return;
            }
            case GATHER: 
            case GATHERV: 
            case REDUCE: {
                location.mpiAllToRoot(event, ssb);
                return;
            }
        }
    }

    private static void addArrow(ITmfStateSystemBuilder ssb, Long startTime, Long endTime, int id, HostThread src, HostThread dest) {
        int edgeQuark = Otf2CallStackStateProvider.getAvailableEdgeQuark(ssb, startTime);
        EdgeStateValue edgeStateValue = new EdgeStateValue(id, src, dest);
        ssb.modifyAttribute(startTime.longValue(), (Object)edgeStateValue, edgeQuark);
        ssb.modifyAttribute(endTime.longValue(), null, edgeQuark);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static int getAvailableEdgeQuark(ITmfStateSystemBuilder ssb, Long startTime) {
        int edgeRoot = ssb.getQuarkAbsoluteAndAdd(new String[]{"Edges"});
        @NonNull List subQuarks = ssb.getSubAttributes(edgeRoot, false);
        Iterator iterator = subQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            long start = ssb.getOngoingStartTime(quark);
            Object value = ssb.queryOngoing(quark);
            if (value != null || start > startTime) continue;
            return quark;
        }
        return ssb.getQuarkRelativeAndAdd(edgeRoot, new String[]{Integer.toString(subQuarks.size())});
    }

    private class Location {
        private final long fLocationId;
        private final int fLocationNameId;
        private final int fProcessId;
        private long fCollectiveBeginTimestamp;
        private int fLocationQuark;
        private int fCallStackQuark;

        public Location(long id, int nameId, int processId) {
            this.fLocationId = id;
            this.fLocationNameId = nameId;
            this.fProcessId = processId;
            this.fCollectiveBeginTimestamp = 0L;
            this.fLocationQuark = -1;
            this.fCallStackQuark = -1;
        }

        public void initializeQuarks(ITmfStateSystemBuilder ssb) {
            String locationName = Otf2CallStackStateProvider.this.getStringFromStringId(this.fLocationNameId);
            Integer processStringId = Otf2CallStackStateProvider.this.fLocationGroupStringId.get(this.fProcessId);
            if (processStringId == null) {
                processStringId = -1;
            }
            String processName = Otf2CallStackStateProvider.this.getStringFromStringId(processStringId);
            int processQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{Otf2CallStackStateProvider.PROCESSES, processName});
            this.fLocationQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{locationName});
            this.fCallStackQuark = ssb.getQuarkRelativeAndAdd(this.fLocationQuark, new String[]{"CallStack"});
        }

        public void enter(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = event.getContent();
            long timestamp = event.getTimestamp().toNanos();
            ssb.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)this.fLocationId), this.fLocationQuark);
            Integer regionRef = (Integer)content.getFieldValue(Integer.class, new String[]{"region"});
            if (regionRef == null) {
                ssb.modifyAttribute(timestamp, null, this.fCallStackQuark);
                return;
            }
            ssb.pushAttribute(timestamp, (Object)Otf2CallStackStateProvider.this.getRegionNameFromRegionId(regionRef), this.fCallStackQuark);
        }

        public void leave(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            long timestamp = event.getTimestamp().toNanos();
            ssb.popAttribute(timestamp, this.fCallStackQuark);
        }

        public void mpiSend(ITmfEvent srcEvent) {
            ITmfEventField content = srcEvent.getContent();
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            if (communicator == null) {
                return;
            }
            Integer srcRank = Otf2CallStackStateProvider.this.getRank(this.fLocationId, communicator);
            Integer destRank = (Integer)content.getFieldValue(Integer.class, new String[]{"receiver"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (destRank == null || messageTag == null || srcRank == -1) {
                return;
            }
            Otf2CallStackStateProvider.this.fMsgDataEvent.put(new MessageIdentifiers(communicator, srcRank, destRank, messageTag), srcEvent);
        }

        public void mpiRecv(ITmfEvent destEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = destEvent.getContent();
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            if (communicator == null) {
                return;
            }
            Integer srcRank = (Integer)content.getFieldValue(Integer.class, new String[]{"sender"});
            Integer destRank = Otf2CallStackStateProvider.this.getRank(this.fLocationId, communicator);
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (srcRank == null || messageTag == null || destRank == -1) {
                return;
            }
            ITmfEvent srcEvent = Otf2CallStackStateProvider.this.fMsgDataEvent.remove(new MessageIdentifiers(communicator, srcRank, destRank, messageTag));
            if (srcEvent == null) {
                return;
            }
            long srcLocationId = Otf2CallStackStateProvider.getLocationId(srcEvent);
            HostThread src = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)srcLocationId));
            HostThread dest = new HostThread(destEvent.getTrace().getHostId(), Integer.valueOf((int)this.fLocationId));
            Otf2CallStackStateProvider.addArrow(ssb, srcEvent.getTimestamp().toNanos(), destEvent.getTimestamp().toNanos(), messageTag, src, dest);
        }

        public void mpiCollectiveBegin(ITmfEvent event) {
            this.fCollectiveBeginTimestamp = event.getTimestamp().toNanos();
        }

        public void mpiRootToAll(ITmfEvent destEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = destEvent.getContent();
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (root == null || communicator == null || operationCode == null) {
                return;
            }
            long srcLocationId = Otf2CallStackStateProvider.this.getLocationIdFromRank(root, communicator);
            CollectiveOperationIdentifiers associatedOperation = null;
            for (RootToAllIdentifiers operationProperties : Otf2CallStackStateProvider.this.fRootToAllQueue) {
                if (!operationProperties.isAssociatedOperation(operationCode, srcLocationId, communicator, this.fLocationId)) continue;
                associatedOperation = operationProperties;
            }
            ITmfEvent srcEvent = null;
            if (associatedOperation == null) {
                srcEvent = destEvent;
                ArrayList members = Otf2CallStackStateProvider.this.getMembersFromCommunicatorReference(communicator);
                ArrayList<Long> pendingLocations = new ArrayList<Long>(members);
                associatedOperation = new RootToAllIdentifiers(operationCode, communicator, srcLocationId, srcEvent, pendingLocations);
                Otf2CallStackStateProvider.this.fRootToAllQueue.add((RootToAllIdentifiers)associatedOperation);
            }
            associatedOperation.locationCalledOperation(this.fLocationId, this.fCollectiveBeginTimestamp);
            if (associatedOperation.isOperationDone()) {
                Otf2CallStackStateProvider.this.fRootToAllQueue.remove(associatedOperation);
            }
            if (srcLocationId == this.fLocationId) {
                return;
            }
            if (srcEvent == null) {
                srcEvent = ((RootToAllIdentifiers)associatedOperation).getBeginEvent();
            }
            HostThread src = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)srcLocationId));
            HostThread dest = new HostThread(destEvent.getTrace().getHostId(), Integer.valueOf((int)this.fLocationId));
            Otf2CallStackStateProvider.addArrow(ssb, srcEvent.getTimestamp().toNanos(), destEvent.getTimestamp().toNanos(), root, src, dest);
        }

        public void mpiAllToRoot(ITmfEvent srcEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = srcEvent.getContent();
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (root == null || communicator == null || operationCode == null) {
                return;
            }
            long destLocationId = Otf2CallStackStateProvider.this.getLocationIdFromRank(root, communicator);
            AllToRootIdentifiers associatedOperation = null;
            for (AllToRootIdentifiers operationProperties : Otf2CallStackStateProvider.this.fAllToRootQueue) {
                if (!operationProperties.isAssociatedOperation(operationCode, destLocationId, communicator, this.fLocationId)) continue;
                associatedOperation = operationProperties;
            }
            if (associatedOperation == null) {
                ArrayList members = Otf2CallStackStateProvider.this.getMembersFromCommunicatorReference(communicator);
                ArrayList<Long> pendingLocations = new ArrayList<Long>(members);
                associatedOperation = new AllToRootIdentifiers(operationCode, communicator, destLocationId, pendingLocations);
                Otf2CallStackStateProvider.this.fAllToRootQueue.add(associatedOperation);
            }
            associatedOperation.locationCalledOperation(this.fLocationId, srcEvent);
            if (associatedOperation.isOperationDone()) {
                Otf2CallStackStateProvider.this.fAllToRootQueue.remove(associatedOperation);
                Collection<ITmfEvent> sentEvents = associatedOperation.getBeginEvents();
                for (ITmfEvent sentEvent : sentEvents) {
                    HostThread src = new HostThread(sentEvent.getTrace().getHostId(), Integer.valueOf((int)Otf2CallStackStateProvider.getLocationId(sentEvent)));
                    HostThread dest = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)Otf2CallStackStateProvider.getLocationId(srcEvent)));
                    Otf2CallStackStateProvider.addArrow(ssb, sentEvent.getTimestamp().toNanos(), srcEvent.getTimestamp().toNanos(), 0, src, dest);
                }
            }
        }
    }
}

