/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.PartSite;

public class ShowViewMenuHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public ShowViewMenuHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        MPart model;
        Composite partContainer;
        IWorkbenchPartSite site;
        IWorkbenchPart part = HandlerUtil.getActivePart(event);
        if (part != null && (site = part.getSite()) instanceof PartSite && (partContainer = (Composite)(model = ((PartSite)site).getModel()).getWidget()) != null) {
            Composite parent = partContainer.getParent();
            while (parent != null) {
                if (parent instanceof CTabFolder) {
                    CTabFolder ctf = (CTabFolder)parent;
                    Control topRight = ctf.getTopRight();
                    if (topRight instanceof Composite) {
                        Control[] controlArray = ((Composite)topRight).getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            if (child instanceof ToolBar && "ViewMenu".equals(child.getData())) {
                                ToolBar tb = (ToolBar)child;
                                ToolItem ti = tb.getItem(0);
                                Event sevent = new Event();
                                sevent.type = 13;
                                sevent.widget = ti;
                                ti.notifyListeners(13, sevent);
                            }
                            ++n2;
                        }
                    }
                    return null;
                }
                parent = parent.getParent();
            }
            MMenu menuModel = StackRenderer.getViewMenu((MPart)model);
            if (menuModel != null) {
                this.showStandaloneViewMenu(event, model, menuModel, partContainer);
            }
        }
        return null;
    }

    private void showStandaloneViewMenu(ExecutionEvent event, MPart model, MMenu menuModel, Composite partContainer) {
        IPresentationEngine engine;
        Shell shell = partContainer.getShell();
        Menu menu = (Menu)menuModel.getWidget();
        if (menu == null && (menu = (Menu)(engine = (IPresentationEngine)HandlerUtil.getVariable(event, IPresentationEngine.class.getName())).createGui((MUIElement)menuModel, (Object)shell, model.getContext())) != null) {
            Menu tmpMenu = menu;
            partContainer.addDisposeListener(e -> tmpMenu.dispose());
        }
        Display display = menu.getDisplay();
        Point location = display.map((Control)partContainer, null, partContainer.getLocation());
        Point size = partContainer.getSize();
        menu.setLocation(location.x + size.x, location.y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!(menu.getData() instanceof MenuManager)) {
            menu.dispose();
        }
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    return EvaluationResult.TRUE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }
}

