/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.io.File;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class WorkingDirectoryBlock
extends AbstractLaunchConfigurationTab {
    private Button fWorkspaceButton;
    private Button fFileSystemButton;
    private Button fVariablesButton;
    private Button fUseDefaultDirButton = null;
    private Button fUseOtherDirButton = null;
    private Text fOtherWorkingText = null;
    private Text fWorkingDirText;
    private ILaunchConfiguration fLaunchConfiguration;
    private final WidgetListener fListener = new WidgetListener();
    private final String workingDirectoryAttribteName;
    private final String helpContextId;

    protected WorkingDirectoryBlock(String workingDirectoryAttribteName) {
        this(workingDirectoryAttribteName, null);
    }

    protected WorkingDirectoryBlock(String workingDirectoryAttribteName, String helpContextId) {
        Assert.isNotNull((Object)workingDirectoryAttribteName);
        this.workingDirectoryAttribteName = workingDirectoryAttribteName;
        this.helpContextId = helpContextId;
    }

    @Override
    public final void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = SWTFactory.createGroup(parent, DebugUIMessages.WorkingDirectoryBlock_12, 2, 1, 768);
        this.setControl((Control)group);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, this.helpContextId);
        }
        Composite comp = SWTFactory.createComposite((Composite)group, font, 2, 2, 1808, 0, 0);
        this.fUseDefaultDirButton = SWTFactory.createRadioButton(comp, DebugUIMessages.WorkingDirectoryBlock_18);
        this.fUseDefaultDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirText = SWTFactory.createSingleText(comp, 1);
        this.fWorkingDirText.addModifyListener((ModifyListener)this.fListener);
        this.fWorkingDirText.setEnabled(false);
        this.fUseOtherDirButton = SWTFactory.createRadioButton(comp, DebugUIMessages.WorkingDirectoryBlock_19);
        this.fUseOtherDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fOtherWorkingText = SWTFactory.createSingleText(comp, 1);
        this.fOtherWorkingText.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = SWTFactory.createComposite(comp, font, 3, 2, 128);
        GridLayout ld = (GridLayout)buttonComp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        this.fWorkspaceButton = this.createPushButton(buttonComp, DebugUIMessages.WorkingDirectoryBlock_0, null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, DebugUIMessages.WorkingDirectoryBlock_1, null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fVariablesButton = this.createPushButton(buttonComp, DebugUIMessages.WorkingDirectoryBlock_17, null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setMessage(DebugUIMessages.WorkingDirectoryBlock_7);
        String currentWorkingDir = this.getWorkingDirectoryText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fOtherWorkingText.setText(selectedDirectory);
        }
    }

    private void handleWorkspaceDirBrowseButtonSelected() {
        IContainer currentContainer = this.getContainer();
        if (currentContainer == null) {
            currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, DebugUIMessages.WorkingDirectoryBlock_4);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.setOtherWorkingDirectoryText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.getWorkingDirectoryText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IPath uriPath = IPath.fromOSString((String)path).makeAbsolute();
                    IContainer[] containers = root.findContainersForLocationURI(URIUtil.toURI((IPath)uriPath));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException e) {
                    this.log(e);
                }
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return null;
    }

    private void handleUseDefaultWorkingDirButtonSelected() {
        this.fWorkspaceButton.setEnabled(false);
        this.fOtherWorkingText.setEnabled(false);
        this.fVariablesButton.setEnabled(false);
        this.fFileSystemButton.setEnabled(false);
        this.fUseOtherDirButton.setSelection(false);
    }

    private void handleUseOtherWorkingDirButtonSelected() {
        this.fOtherWorkingText.setEnabled(true);
        this.fWorkspaceButton.setEnabled(true);
        this.fVariablesButton.setEnabled(true);
        this.fFileSystemButton.setEnabled(true);
        this.updateLaunchConfigurationDialog();
    }

    private void handleWorkingDirVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.fOtherWorkingText.insert(variableText);
        }
    }

    protected void setDefaultWorkingDir() {
        try {
            IProject project;
            ILaunchConfiguration config = this.getLaunchConfiguration();
            if (config != null && (project = this.getProject(config)) != null) {
                this.setDefaultWorkingDirectoryText("${workspace_loc:" + project.getFullPath().makeRelative().toOSString() + "}");
                return;
            }
        }
        catch (CoreException ce) {
            this.log(ce);
        }
        this.setDefaultWorkingDirectoryText(System.getProperty("user.dir"));
    }

    protected abstract IProject getProject(ILaunchConfiguration var1) throws CoreException;

    @Override
    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.getWorkingDirectoryText();
        if (workingDirPath.contains("${")) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0) {
            IContainer container = this.getContainer();
            if (container == null) {
                File dir = new File(workingDirPath);
                if (dir.isDirectory()) {
                    return true;
                }
                this.setErrorMessage(DebugUIMessages.WorkingDirectoryBlock_10);
                return false;
            }
        } else if (workingDirPath.length() == 0) {
            this.setErrorMessage(DebugUIMessages.WorkingDirectoryBlock_20);
            return false;
        }
        return true;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(this.workingDirectoryAttribteName, null);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute(this.workingDirectoryAttribteName, null);
            this.setDefaultWorkingDir();
            if (wd != null) {
                this.setOtherWorkingDirectoryText(wd);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(DebugUIMessages.WorkingDirectoryBlock_Exception_occurred_reading_configuration___15 + e.getStatus().getMessage());
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fUseDefaultDirButton.getSelection()) {
            configuration.setAttribute(this.workingDirectoryAttribteName, null);
        } else {
            configuration.setAttribute(this.workingDirectoryAttribteName, this.getWorkingDirectoryText());
        }
    }

    @Override
    public String getName() {
        return DebugUIMessages.WorkingDirectoryBlock_Working_Directory_8;
    }

    protected void log(CoreException e) {
    }

    protected final String getWorkingDirectoryText() {
        if (this.fUseDefaultDirButton.getSelection()) {
            return this.fWorkingDirText.getText().trim();
        }
        return this.fOtherWorkingText.getText().trim();
    }

    protected final void setDefaultWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fWorkingDirText.setText(dir);
            this.fUseDefaultDirButton.setSelection(true);
            this.handleUseDefaultWorkingDirButtonSelected();
        }
    }

    protected final void setOtherWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fOtherWorkingText.setText(dir);
            this.fUseDefaultDirButton.setSelection(false);
            this.fUseOtherDirButton.setSelection(true);
            this.handleUseOtherWorkingDirButtonSelected();
        }
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    public final void setEnabled(boolean enabled) {
        this.fUseDefaultDirButton.setEnabled(enabled);
        this.fUseOtherDirButton.setEnabled(enabled);
        if (this.fOtherWorkingText.isEnabled()) {
            this.fOtherWorkingText.setEnabled(enabled);
            this.fWorkspaceButton.setEnabled(enabled);
            this.fVariablesButton.setEnabled(enabled);
            this.fFileSystemButton.setEnabled(enabled);
        }
        if (this.fUseOtherDirButton.getSelection() && enabled) {
            this.fOtherWorkingText.setEnabled(enabled);
        }
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            WorkingDirectoryBlock.this.scheduleUpdateJob();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.fWorkspaceButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fFileSystemButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fVariablesButton) {
                WorkingDirectoryBlock.this.handleWorkingDirVariablesButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fUseDefaultDirButton) {
                if (WorkingDirectoryBlock.this.fUseDefaultDirButton.getSelection()) {
                    WorkingDirectoryBlock.this.setDefaultWorkingDir();
                }
            } else if (source == WorkingDirectoryBlock.this.fUseOtherDirButton && WorkingDirectoryBlock.this.fUseOtherDirButton.getSelection()) {
                WorkingDirectoryBlock.this.handleUseOtherWorkingDirButtonSelected();
            }
        }
    }
}

