/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.Collections;
import java.util.Map;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.IScriptDebugFrame;

public class EaseDebugFrame
implements IScriptDebugFrame {
    private final Script fScript;
    private int fLineNumber;
    private final int fType;
    private final String fName;

    public EaseDebugFrame(Script script, int lineNumber, int type, String name) {
        this.fScript = script;
        this.fLineNumber = lineNumber;
        this.fType = type;
        this.fName = name;
    }

    public EaseDebugFrame(Script script, int lineNumber, int type) {
        this(script, lineNumber, type, null);
    }

    public EaseDebugFrame(IScriptDebugFrame frame) {
        this(frame.getScript(), frame.getLineNumber(), frame.getType(), frame.getName());
    }

    @Override
    public int getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public Script getScript() {
        return this.fScript;
    }

    @Override
    public int getType() {
        return this.fType;
    }

    @Override
    public String getName() {
        return this.fName != null ? this.fName : "";
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    @Override
    public void setVariable(String name, Object content) {
        throw new UnsupportedOperationException("Setting variables is not supported");
    }

    @Override
    public Object inject(String expression) throws Throwable {
        throw new UnsupportedOperationException("Executing code on a stackframe is not supported");
    }

    public Map<String, Object> getVariables() {
        return Collections.emptyMap();
    }
}

