/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.config;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;

public class TmfConfigParamDescriptor
implements ITmfConfigParamDescriptor {
    private final String fKeyName;
    private final String fDescription;
    private final String fDataType;
    private final boolean fIsRequired;

    private TmfConfigParamDescriptor(Builder builder) {
        this.fKeyName = builder.fKeyName;
        this.fDescription = builder.fDescription;
        this.fDataType = builder.fDataType;
        this.fIsRequired = builder.fIsRequired;
    }

    @Override
    public String getKeyName() {
        return this.fKeyName;
    }

    @Override
    public String getDataType() {
        return this.fDataType;
    }

    @Override
    public boolean isRequired() {
        return this.fIsRequired;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "fKeyName=" + this.getKeyName() + ", fDataType=" + this.getDataType() + ", fIsRequired=" + this.isRequired() + ", fDescription=" + this.getDescription() + "]";
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof TmfConfigParamDescriptor)) {
            return false;
        }
        TmfConfigParamDescriptor other = (TmfConfigParamDescriptor)arg0;
        return Objects.equals(this.fKeyName, other.fKeyName) && Objects.equals(this.fDataType, other.fDataType) && Objects.equals(this.fDescription, other.fDescription) && Objects.equals(this.fIsRequired, other.fIsRequired);
    }

    public int hashCode() {
        return Objects.hash(this.fKeyName, this.fIsRequired, this.fDataType, this.fDescription);
    }

    public static class Builder {
        private String fKeyName = "";
        private String fDescription = "";
        private String fDataType = "STRING";
        private boolean fIsRequired = true;

        public Builder setDataType(String dataType) {
            this.fDataType = dataType;
            return this;
        }

        public Builder setKeyName(String keyName) {
            this.fKeyName = keyName;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setIsRequired(boolean isRequired) {
            this.fIsRequired = isRequired;
            return this;
        }

        public ITmfConfigParamDescriptor build() {
            String keyName = this.fKeyName;
            if (keyName.isBlank()) {
                throw new IllegalStateException("The key name of the configuration parameter is not set");
            }
            return new TmfConfigParamDescriptor(this);
        }
    }
}

