/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.analysis.core.reports.IReportDataProvider;
import org.eclipse.tracecompass.incubator.analysis.core.reports.ReportsDataProviderFactory;
import org.eclipse.tracecompass.incubator.internal.analysis.core.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.eclipse.tracecompass.tmf.core.model.DataProviderCapabilities;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ImageReportDataProvider
implements IReportDataProvider {
    private static final String[] VALID_EXTENSIONS = new String[]{"png", "jpg", "jpeg", "svg"};
    private static final String PATH = "path";
    private static final String PATH_DESCRIPTION = "The path to the image file";
    private static final ITmfConfigurationSourceType CONFIGURATION_SOURCE_TYPE;
    private static final List<@NonNull ITmfConfigParamDescriptor> CONFIGURATION_DESCRIPTORS;
    private static final String CONFIGURATION_ID = "org.eclipse.tracecompass.incubator.analysis.core.reports.image.config";
    private static final String CONFIGURATION_NAME = "Image Report Configurator";
    private static final String CONFIGURATION_DESCRIPTION = "Configure custom image reports (e.g., png, jpg, etc.)";

    static {
        CONFIGURATION_DESCRIPTORS = List.of(new TmfConfigParamDescriptor.Builder().setKeyName(PATH).setDescription(PATH_DESCRIPTION).setIsRequired(true).build());
        CONFIGURATION_SOURCE_TYPE = new TmfConfigurationSourceType.Builder().setId(CONFIGURATION_ID).setName(CONFIGURATION_NAME).setDescription(CONFIGURATION_DESCRIPTION).setConfigParamDescriptors(Objects.requireNonNull(CONFIGURATION_DESCRIPTORS)).build();
    }

    @Override
    public @NonNull IDataProviderDescriptor createDescriptor(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        IStatus status;
        this.validateConfiguration(configuration);
        String description = configuration.getDescription();
        if (description.equals("---unknown---")) {
            description = configuration.getName();
        }
        if (!(status = ImageReportDataProvider.createImage(trace, configuration)).isOK()) {
            throw new TmfConfigurationException(status.getMessage());
        }
        return this.getDescriptorFromConfig(trace, new TmfConfiguration.Builder().setId(configuration.getId()).setSourceTypeId(configuration.getSourceTypeId()).setName(configuration.getName()).setDescription(description).setParameters(configuration.getParameters()).build());
    }

    @Override
    public @NonNull IDataProviderDescriptor getDescriptorFromConfig(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) {
        return new DataProviderDescriptor.Builder().setId(configuration.getId()).setName(configuration.getName()).setDescription(configuration.getDescription()).setProviderType(IDataProviderDescriptor.ProviderType.NONE).setConfiguration(configuration).setCapabilities(new DataProviderCapabilities.Builder().setCanDelete(true).build()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus createImage(ITmfTrace trace, ITmfConfiguration configuration) {
        File toFile;
        block34: {
            Activator.getInstance().logInfo("Creating image report configuration " + configuration.getName() + " for trace " + trace.getName());
            Path originalPath = new Path((String)configuration.getParameters().get(PATH));
            if (!originalPath.toFile().exists()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", "The given image path does not exist");
            }
            if (originalPath.toFile().isDirectory()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", "The given image path is a directory");
            }
            String extension = originalPath.getFileExtension();
            if (extension == null) return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", "Invalid image file extension. Supported extensions are: " + String.join((CharSequence)", ", VALID_EXTENSIONS));
            if (!extension.matches(String.join((CharSequence)"|", VALID_EXTENSIONS))) {
                return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", "Invalid image file extension. Supported extensions are: " + String.join((CharSequence)", ", VALID_EXTENSIONS));
            }
            IPath reportsPath = ReportsDataProviderFactory.getConfigurationBasePath(trace, ReportsDataProviderFactory.getConfigurationParent(trace, configuration)).addTrailingSeparator().append(configuration.getId());
            File fromFile = originalPath.toFile();
            toFile = reportsPath.addTrailingSeparator().append(configuration.getName()).addFileExtension(extension).toFile();
            try {
                boolean success;
                File parentDir = toFile.getParentFile();
                if (!parentDir.exists() && !(success = parentDir.mkdirs())) {
                    throw new IllegalStateException("Directory " + parentDir.getAbsolutePath() + " failed to create.");
                }
                if (!toFile.exists() && !(success = toFile.createNewFile())) {
                    throw new IllegalStateException("File " + toFile.getAbsolutePath() + " failed to create.");
                }
            }
            catch (IOException e) {
                String error = "Failed to create destination file";
                return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", error, (Throwable)e);
            }
            try {
                Throwable e = null;
                Object var8_13 = null;
                try {
                    FileInputStream fis = new FileInputStream(fromFile);
                    try {
                        block33: {
                            FileOutputStream fos = new FileOutputStream(toFile);
                            try {
                                block32: {
                                    FileChannel source = fis.getChannel();
                                    try {
                                        try (FileChannel destination = fos.getChannel();){
                                            destination.transferFrom(source, 0L, source.size());
                                            Activator.getInstance().logInfo("Image file copied from " + fromFile.getAbsolutePath() + " to " + toFile.getAbsolutePath() + " of configuration " + configuration.getName() + " for trace " + trace.getName());
                                        }
                                        if (source == null) break block32;
                                    }
                                    catch (Throwable throwable) {
                                        if (e == null) {
                                            e = throwable;
                                        } else if (e != throwable) {
                                            e.addSuppressed(throwable);
                                        }
                                        if (source == null) throw e;
                                        source.close();
                                        throw e;
                                    }
                                    source.close();
                                }
                                if (fos == null) break block33;
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                if (fos == null) throw e;
                                fos.close();
                                throw e;
                            }
                            fos.close();
                        }
                        if (fis == null) break block34;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        if (fis == null) throw e;
                        fis.close();
                        throw e;
                    }
                    fis.close();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                        throw e;
                    }
                    if (e == throwable) throw e;
                    e.addSuppressed(throwable);
                    throw e;
                }
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.tracecompass.incubator.analysis.core", "Failed to copy image file", (Throwable)e);
            }
        }
        configuration.getParameters().put(PATH, toFile.getAbsolutePath());
        Activator.getInstance().logInfo("Image report configuration " + configuration.getName() + " for trace " + trace.getName() + " created successfully");
        return Status.OK_STATUS;
    }

    @Override
    public IReportDataProvider.ReportProviderType getReportType() {
        return IReportDataProvider.ReportProviderType.IMAGE;
    }

    @Override
    public ITmfConfigurationSourceType getConfigurationSourceType() {
        return CONFIGURATION_SOURCE_TYPE;
    }

    @Override
    public void validateConfiguration(@NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        Map parameters = configuration.getParameters();
        if (!parameters.containsKey(PATH)) {
            throw new TmfConfigurationException("Image path is required");
        }
        Object path = parameters.get(PATH);
        if (!(path instanceof String) || ((String)path).isEmpty()) {
            throw new TmfConfigurationException("Invalid image path");
        }
    }

    @Override
    public @NonNull IDataProviderDescriptor removeDescriptor(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        File imageFile = new Path((String)configuration.getParameters().get(PATH)).toFile();
        if (imageFile.exists() && !imageFile.delete()) {
            throw new TmfConfigurationException("Failed to delete image file");
        }
        Activator.getInstance().logInfo("Image file " + imageFile.getAbsolutePath() + " of configuration " + configuration.getName() + " for trace " + trace.getName() + " deleted successfully");
        return this.getDescriptorFromConfig(trace, configuration);
    }
}

