/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;

public class ImportDeclaration
extends ASTNode {
    public static final ChildPropertyDescriptor SOURCE_PROPERTY = new ChildPropertyDescriptor(ImportDeclaration.class, "source", StringLiteral.class, true, false);
    public static final ChildListPropertyDescriptor SPECIFIERS_PROPERTY = new ChildListPropertyDescriptor(ImportDeclaration.class, "specifiers", ModuleSpecifier.class, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ImportDeclaration.class, "name", Name.class, true, false);
    public static final SimplePropertyDescriptor ON_DEMAND_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "onDemand", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor STATIC_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "static", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor ISFILE_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "isFile", Boolean.TYPE, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private StringLiteral source;
    private ASTNode.NodeList specifiers = new ASTNode.NodeList(SPECIFIERS_PROPERTY);
    private Name importName = null;
    private boolean onDemand = false;
    private boolean isStatic = false;
    private boolean isFile = false;

    static {
        ArrayList properyList = new ArrayList(6);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(STATIC_PROPERTY, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        ImportDeclaration.addProperty(ISFILE_PROPERTY, properyList);
        ImportDeclaration.addProperty(SOURCE_PROPERTY, properyList);
        ImportDeclaration.addProperty(SPECIFIERS_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = ImportDeclaration.reapPropertyList(properyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    ImportDeclaration(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ImportDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == ON_DEMAND_PROPERTY) {
            if (get) {
                return this.isOnDemand();
            }
            this.setOnDemand(value);
            return false;
        }
        if (property == STATIC_PROPERTY) {
            if (get) {
                return this.isStatic();
            }
            this.setStatic(value);
            return false;
        }
        if (property == ISFILE_PROPERTY) {
            if (get) {
                return this.isFileImport();
            }
            this.setIsFileImport(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == SPECIFIERS_PROPERTY) {
            return this.specifiers();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        if (property == SOURCE_PROPERTY) {
            if (get) {
                return this.getSource();
            }
            this.setSource((StringLiteral)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 26;
    }

    @Override
    ASTNode clone0(AST target) {
        ImportDeclaration result = new ImportDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOnDemand(this.isOnDemand());
        result.setIsFileImport(this.isFileImport());
        if (this.ast.apiLevel >= 3) {
            result.setStatic(this.isStatic());
        }
        result.setName((Name)this.getName().clone(target));
        result.setSource((StringLiteral)this.getSource().clone(target));
        result.specifiers.addAll(ASTNode.copySubtrees(target, this.specifiers()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.specifiers);
            this.acceptChild(visitor, this.getSource());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.importName == null) {
            ImportDeclaration importDeclaration = this;
            synchronized (importDeclaration) {
                if (this.importName == null) {
                    this.preLazyInit();
                    this.importName = this.ast.newQualifiedName(new SimpleName(this.ast), new SimpleName(this.ast));
                    this.postLazyInit(this.importName, NAME_PROPERTY);
                }
            }
        }
        return this.importName;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.importName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.importName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public void setOnDemand(boolean onDemand) {
        this.preValueChange(ON_DEMAND_PROPERTY);
        this.onDemand = onDemand;
        this.postValueChange(ON_DEMAND_PROPERTY);
    }

    public void setIsFileImport(boolean isFileImport) {
        this.preValueChange(ISFILE_PROPERTY);
        this.isFile = isFileImport;
        this.postValueChange(ISFILE_PROPERTY);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.preValueChange(STATIC_PROPERTY);
        this.isStatic = isStatic;
        this.postValueChange(STATIC_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringLiteral getSource() {
        if (this.source == null) {
            ImportDeclaration importDeclaration = this;
            synchronized (importDeclaration) {
                if (this.source == null) {
                    this.preLazyInit();
                    this.source = this.ast.newStringLiteral();
                    this.postLazyInit(this.source, SOURCE_PROPERTY);
                }
            }
        }
        return this.source;
    }

    public void setSource(StringLiteral source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        StringLiteral oldChild = this.source;
        this.preReplaceChild(oldChild, source, SOURCE_PROPERTY);
        this.source = source;
        this.postReplaceChild(oldChild, source, SOURCE_PROPERTY);
    }

    public List specifiers() {
        return this.specifiers;
    }

    public IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveImport(this);
    }

    @Override
    int memSize() {
        return 60;
    }

    @Override
    int treeSize() {
        return this.memSize() + this.specifiers.listSize() + (this.source == null ? 0 : this.getSource().treeSize()) + (this.importName == null ? 0 : this.getName().treeSize());
    }

    public boolean isFileImport() {
        return this.isFile;
    }
}

