/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.event;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.ITraceEventAspect;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.Messages;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;

public class TraceEventAspects {
    public static final ITmfEventAspect<Map<String, Object>> ARGS_ASPECT = new TraceCompassScopeLogArgsAspect();
    public static final ITmfEventAspect<String> ID_ASPECT = new TraceCompassScopeLogIdAspect();
    public static final ITmfEventAspect<String> CATEGORY_ASPECT = new TraceCompassScopeLogCategoryAspect();
    private static Iterable<@NonNull ITmfEventAspect<?>> aspects;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Iterable<@NonNull ITmfEventAspect<?>> getAspects() {
        @NonNull ImmutableList aspectSet = aspects;
        if (aspectSet == null) {
            aspects = aspectSet = ImmutableList.of((Object)new TraceCompassScopeLogLabelAspect(), (Object)TmfBaseAspects.getTimestampAspect(), (Object)new TraceCompassLogPhaseAspect(), (Object)new TraceCompassScopeLogLevel(), (Object)((Object)new TraceCompassScopeLogTidAspect()), (Object)new TraceCompassScopeLogPidAspect(), CATEGORY_ASPECT, (Object)new TraceCompassScopeLogDurationAspect(), ID_ASPECT, ARGS_ASPECT, (Object)new TraceCompassScopeLogCallsiteAspect());
        }
        return aspectSet;
    }

    private static class TraceCompassLogPhaseAspect
    implements ITraceEventAspect<String> {
        private TraceCompassLogPhaseAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Phase);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_PhaseD);
        }

        @Override
        public @Nullable String resolveTCL(TraceEventEvent event) {
            return String.valueOf(event.getField().getPhase());
        }
    }

    private static class TraceCompassScopeLogArgsAspect
    implements ITraceEventAspect<Map<String, Object>> {
        private TraceCompassScopeLogArgsAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Args);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_ArgsD);
        }

        @Override
        public @Nullable Map<String, Object> resolveTCL(@NonNull TraceEventEvent event) {
            return event.getField().getArgs();
        }
    }

    private static class TraceCompassScopeLogCallsiteAspect
    implements ITraceEventAspect<ITmfCallsite> {
        private TraceCompassScopeLogCallsiteAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Callsite);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_CallsiteD);
        }

        @Override
        public @Nullable ITmfCallsite resolveTCL(@NonNull TraceEventEvent event) {
            return event.getCallsite();
        }
    }

    private static class TraceCompassScopeLogCategoryAspect
    implements ITraceEventAspect<String> {
        private TraceCompassScopeLogCategoryAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Category);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_CategoryD);
        }

        @Override
        public @Nullable String resolveTCL(@NonNull TraceEventEvent event) {
            return event.getField().getCategory();
        }
    }

    private static class TraceCompassScopeLogDurationAspect
    implements ITraceEventAspect<Long> {
        private TraceCompassScopeLogDurationAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceEventAspects_Duration);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceEventAspects_DurationD);
        }

        @Override
        public @Nullable Long resolveTCL(@NonNull TraceEventEvent event) {
            return event.getField().getDuration();
        }
    }

    private static class TraceCompassScopeLogIdAspect
    implements ITraceEventAspect<String> {
        private TraceCompassScopeLogIdAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Id);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_IdD);
        }

        @Override
        public @Nullable String resolveTCL(@NonNull TraceEventEvent event) {
            return event.getField().getId();
        }
    }

    private static class TraceCompassScopeLogLabelAspect
    implements ITraceEventAspect<String> {
        private TraceCompassScopeLogLabelAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_Name);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_NameD);
        }

        @Override
        public @Nullable String resolveTCL(@NonNull TraceEventEvent event) {
            return event.getName();
        }
    }

    private static class TraceCompassScopeLogLevel
    implements ITraceEventAspect<Level> {
        private TraceCompassScopeLogLevel() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_LogLevel);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceCompassScopeLogAspects_LogLevelD);
        }

        @Override
        public @Nullable Level resolveTCL(@NonNull TraceEventEvent event) {
            return event.getLevel();
        }
    }

    public static class TraceCompassScopeLogPidAspect
    implements ITraceEventAspect<String> {
        public @NonNull String getName() {
            return String.valueOf(Messages.TraceEventAspects_Pid);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.TraceEventAspects_PidD);
        }

        @Override
        public @Nullable String resolveTCL(@NonNull TraceEventEvent event) {
            Object field = event.getField().getPid();
            if (field != null) {
                return String.valueOf(field);
            }
            return null;
        }
    }

    private static class TraceCompassScopeLogTidAspect
    extends LinuxTidAspect {
        private TraceCompassScopeLogTidAspect() {
        }

        public boolean isHiddenByDefault() {
            return false;
        }

        public @Nullable Integer resolve(@NonNull ITmfEvent event) {
            if (event instanceof TraceEventEvent) {
                return ((TraceEventEvent)event).getField().getTid();
            }
            return null;
        }
    }
}

