/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.BookmarkManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ConfigurationManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.DataProviderService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.HealthService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.IdentifierService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceServerOpenApiResource;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.CORSFilter;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.JacksonObjectMapperProvider;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.RequestResponseLogger;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TraceServerConfiguration;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.servlet.ServletContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class WebApplication {
    private static final String CONTEXT_PATH = "/tsp/api";
    private static final String PATH_SPEC = "/*";
    private Server fServer;
    private final TraceServerConfiguration fConfig;

    public WebApplication() {
        this(TraceServerConfiguration.create());
    }

    public WebApplication(TraceServerConfiguration config) {
        this.fConfig = config;
    }

    public void start() throws Exception {
        IFolder tracesFolder;
        ServletContextHandler sch = new ServletContextHandler();
        sch.setContextPath(CONTEXT_PATH);
        ResourceConfig rc = new ResourceConfig();
        this.registerResourcesAndMappers(rc);
        ServletContainer sc = new ServletContainer(rc);
        ServletHolder holder = new ServletHolder((Servlet)sc);
        sch.addServlet(holder, PATH_SPEC);
        this.fServer = new Server();
        ServerConnector connector = WebApplication.getConnector(this.fServer, this.fConfig);
        this.fServer.addConnector((Connector)connector);
        this.fServer.setHandler((Supplier)sch);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        if (!project.exists()) {
            project.create(null);
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
            project.setDescription(description, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(tracesFolder = project.getFolder("Traces")).exists()) {
            tracesFolder.create(true, true, null);
        }
        this.fServer.start();
    }

    protected void registerResourcesAndMappers(ResourceConfig rc) {
        rc.register(ConfigurationManagerService.class);
        rc.register(TraceManagerService.class);
        rc.register(ExperimentManagerService.class);
        rc.register(DataProviderService.class);
        rc.register(HealthService.class);
        rc.register(IdentifierService.class);
        rc.register(CORSFilter.class);
        rc.register(JacksonObjectMapperProvider.class);
        EncodingFilter.enableFor((ResourceConfig)rc, (Class[])new Class[]{GZipEncoder.class});
        rc.register(TraceServerOpenApiResource.class);
        rc.register(BookmarkManagerService.class);
        rc.register(RequestResponseLogger.class);
    }

    protected static ServerConnector getConnector(Server server, TraceServerConfiguration config) {
        ServerConnector serverConnector = null;
        if (config.useSSL()) {
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            contextFactory.setKeyStorePath(config.getKeystore());
            contextFactory.setKeyStorePassword(config.getKeystorePass());
            contextFactory.setTrustAll(true);
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.setSecureScheme("https");
            httpsConfig.setOutputBufferSize(32768);
            httpsConfig.setRequestHeaderSize(16384);
            httpsConfig.setResponseHeaderSize(16384);
            httpsConfig.setSendServerVersion(true);
            httpsConfig.setSendDateHeader(false);
            SslConnectionFactory connector = new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString());
            serverConnector = new ServerConnector(server, new ConnectionFactory[]{connector, new HttpConnectionFactory(httpsConfig)});
        } else {
            serverConnector = new ServerConnector(server);
        }
        serverConnector.setHost(config.getHost());
        serverConnector.setPort(config.getPort());
        return serverConnector;
    }

    public void dispose() {
        ExperimentManagerService.dispose();
        TraceManagerService.dispose();
    }

    public void stop() {
        try {
            this.fServer.stop();
        }
        catch (Exception ex) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Error stopping server", (Throwable)ex));
        }
    }
}

