/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.queues;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.AbstractRosPresentationProvider;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class RosQueuesPresentationProvider
extends AbstractRosPresentationProvider {
    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        String entryName = entry.getName();
        if (StringUtils.isNumeric((CharSequence)entryName)) {
            return Messages.AbstractRosPresentationProvider_QueuePosition;
        }
        return null;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        String label = event.getLabel();
        if (label == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String entryName = event.getEntry().getName();
        String nodeName = Messages.AbstractRosPresentationProvider_Unknown;
        String topicName = Messages.AbstractRosPresentationProvider_Unknown;
        if (StringUtils.isNumeric((CharSequence)entryName)) {
            topicName = event.getEntry().getParent().getParent().getName();
            nodeName = event.getEntry().getParent().getParent().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_QueueReference, (Object)label);
        } else if (entryName.equals("queue")) {
            topicName = event.getEntry().getParent().getName();
            nodeName = event.getEntry().getParent().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_QueueSize, (Object)label);
        } else if (entryName.equals("message processing")) {
            topicName = event.getEntry().getParent().getName();
            nodeName = event.getEntry().getParent().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_QueueReference, (Object)label);
        } else if (entryName.equals("drops")) {
            topicName = event.getEntry().getParent().getName();
            nodeName = event.getEntry().getParent().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_QueueReference, (Object)label);
        } else if (entryName.equals("callbacks")) {
            nodeName = event.getEntry().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_QueueReference, (Object)label);
        }
        builder.put((Object)Messages.AbstractRosPresentationProvider_TopicName, (Object)topicName);
        builder.put((Object)Messages.AbstractRosPresentationProvider_NodeName, (Object)nodeName);
        return builder.build();
    }
}

