/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.impl.AttributeAware;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.core.impl.PsopFragment;

public final class Psop
extends AttributeAware
implements IPsop {
    private final List<IPsopFragment> fragments = new ArrayList<IPsopFragment>();

    @Override
    public List<IPsopFragment> getFragments() {
        return this.fragments;
    }

    public void add(IPsopFragment f) {
        this.addAtEnd(f);
    }

    public void addAtBegin(IPsopFragment f) {
        if (!this.fragments.isEmpty()) {
            IPsopFragment lf = this.fragments.get(0);
            this.check(f, lf);
        }
        this.fragments.add(0, f);
    }

    public void addAtEnd(IPsopFragment f) {
        if (!this.fragments.isEmpty()) {
            IPsopFragment last = this.fragments.get(this.fragments.size() - 1);
            this.check(last, f);
            if (f.getA().doubleValue() == 0.0 && f.getB().doubleValue() == 0.0 && last.getA().doubleValue() == 0.0 && last.getB().doubleValue() == 0.0 && f.getC().doubleValue() == last.getC().doubleValue()) {
                this.fragments.remove(this.fragments.size() - 1);
                this.fragments.add(new PsopFragment(f.getC(), f.getB(), f.getA(), new Interval(last.dom().lb(), false, f.dom().ub(), true)));
            } else {
                this.fragments.add(f);
            }
        } else {
            this.fragments.add(f);
        }
    }

    public void merge() {
        int i = 0;
        while (i < this.fragments.size() - 1) {
            IPsopFragment f1;
            IPsopFragment f0 = this.fragments.get(i);
            if (this.mergeable(f0, f1 = this.fragments.get(i + 1))) {
                this.fragments.remove(i);
                this.fragments.remove(i);
                this.fragments.add(i, new PsopFragment(f0.getC(), f0.getB(), f0.getA(), new Interval(f0.dom().lb(), false, f1.dom().ub(), true)));
                continue;
            }
            ++i;
        }
    }

    private boolean mergeable(IPsopFragment f0, IPsopFragment f1) {
        double x = f0.dom().ub().doubleValue();
        return f0.getA().doubleValue() == f1.getA().doubleValue() && Math.abs(PsopHelper.valueAt(f0, (Number)x).doubleValue() - f1.getC().doubleValue()) < 1.0E-12 && Math.abs(PsopHelper.valueDerivativeAt(f0, x).doubleValue() - f1.getB().doubleValue()) < 1.0E-12;
    }

    private void check(IPsopFragment f1, IPsopFragment f2) {
        if (f1.dom().ub().doubleValue() != f2.dom().lb().doubleValue()) {
            throw new IllegalArgumentException("non-consecutive fragments");
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("Psop[attributes=" + this.getAttributes());
        b.append(", fragments:\n");
        for (IPsopFragment f : this.fragments) {
            b.append("\t").append(f.toString()).append("\n");
        }
        b.append("]\n");
        return b.toString();
    }
}

