/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.trace4cps.analysis.timing.StatisticsManager;
import org.eclipse.trace4cps.analysis.timing.TimingAnalysis;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.eclipse.trace4cps.ui.view.timing.TimingAnalysisView;

public class TimingAnalysisAction
extends AbstractTraceViewAction {
    public TimingAnalysisAction(TraceView view) {
        super(view, "/icons/graph.png");
        this.setToolTipText("Timing analysis");
    }

    public boolean isEnabled() {
        return this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        HashMap<String, Map<String, StatisticsManager>> timingData = new HashMap<String, Map<String, StatisticsManager>>();
        int i = 0;
        while (i < this.view.getNumTraces()) {
            Map timing = TimingAnalysis.analyse((ITrace)this.view.getTrace(i), (Collection)this.viewCfg.getGroupingAttributes(TracePart.CLAIM));
            timingData.put(this.view.getTraceFile(i).getName(), timing);
            ++i;
        }
        TimingAnalysisView.openView(timingData);
    }
}

