/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.constraintgraph.ConstraintConfig;
import org.eclipse.trace4cps.analysis.cpa.CpaResult;
import org.eclipse.trace4cps.analysis.cpa.CriticalPathAnalysis;
import org.eclipse.trace4cps.analysis.cpa.DependencyProvider;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.AnalysisUtil;
import org.eclipse.trace4cps.ui.dialog.CPAdialog;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class CriticalPathAction
extends AbstractTraceViewAction {
    public CriticalPathAction(TraceView view) {
        super(view, "/icons/cpa.png");
        this.setToolTipText("Critical-path analysis");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasEvents(true, true);
    }

    @Override
    protected void doRun() throws TraceException {
        CPAdialog dialog = new CPAdialog(this.view.getEditorSite().getShell());
        if (dialog.open() == 0) {
            Provider p = null;
            if (dialog.useDependencies() == CPAdialog.DependencyUse.APP) {
                p = new Provider(this.view.getTrace());
            }
            ConstraintConfig config = ConstraintConfig.getDefault();
            config.setAddSourceAndSink(true);
            config.setAddClaimDurations(true);
            if (dialog.useDependencies() != CPAdialog.DependencyUse.FULL) {
                config.setApplyOrderingHeuristic(dialog.getEpsilon());
            } else {
                config.setUseDependencies(true);
            }
            CpaResult cpaResult = CriticalPathAnalysis.run((ITrace)this.view.getTrace(), (ConstraintConfig)config);
            this.viewCfg.setHighlightMap(AnalysisUtil.createHighlight(cpaResult, p));
            this.view.clearExtensions(TracePart.DEPENDENCY);
            this.view.addDependencyExtension(cpaResult.getCriticalDeps(), 0);
            this.view.update();
        }
    }

    private static final class Provider
    implements DependencyProvider {
        private final Map<IEvent, Set<IEvent>> succs = new HashMap<IEvent, Set<IEvent>>();

        public Provider(ITrace trace) {
            for (IDependency dep : trace.getDependencies()) {
                IEvent src = dep.getSrc();
                IEvent dst = dep.getDst();
                Set<IEvent> events = this.succs.get(src);
                if (events == null) {
                    events = new HashSet<IEvent>();
                    this.succs.put(src, events);
                }
                events.add(dst);
            }
        }

        public boolean isApplicationDependency(IEvent src, IEvent dst) {
            Set<IEvent> s = this.succs.get(src);
            if (s != null) {
                return s.contains(dst);
            }
            return false;
        }
    }
}

