/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.ui.dialog.ParameterDialog;

public final class ResourceClientHistogramDialog
extends ParameterDialog {
    private static final String TITLE = "Resource-usage analysis";
    private static final String CUMULATIVE_KEY = "CUMULATIVE";
    private static final String AMOUNT_KEY = "AMOUNT";
    private final boolean isHistoDialog;
    private final Map<String, IResource> resourceMap = new HashMap<String, IResource>();

    public ResourceClientHistogramDialog(Shell parentShell, Collection<IResource> resources, boolean isHistoDialog) {
        super(parentShell, ResourceClientHistogramDialog.class.getName());
        this.isHistoDialog = isHistoDialog;
        for (IResource r : resources) {
            this.resourceMap.put(TraceHelper.getValues((IAttributeAware)r, (boolean)true), r);
        }
    }

    public boolean cumulative() {
        return this.get(CUMULATIVE_KEY, Boolean.class);
    }

    public List<IResource> getSelected() {
        ArrayList<IResource> r = new ArrayList<IResource>();
        for (String s : this.getSelection()) {
            r.add(this.resourceMap.get(s));
        }
        return r;
    }

    public boolean useAmount() {
        return this.get(AMOUNT_KEY, Boolean.class);
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected void draw(Composite composite) {
        Group gr = new Group(composite, 4);
        gr.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData(4, 4, true, false);
        gr.setLayoutData((Object)data);
        if (this.isHistoDialog) {
            this.addCheckbox((Composite)gr, "Use cumulative values", CUMULATIVE_KEY, false);
        } else {
            this.addCheckbox((Composite)gr, "Use resource amount", AMOUNT_KEY, true);
            this.addPositiveDoubleInput((Composite)gr, true);
        }
        this.addSelectionInput(composite, "Select resources", ParameterDialog.SelectionType.AT_LEAST_ONE, this.resourceMap.keySet());
        ResourceClientHistogramDialog.applyDialogFont((Control)composite);
    }
}

