/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.concurrent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.concurrent.Executors;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.IExecutorUtilDelegate;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.INestableExecutor;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.ISingleThreadedExecutor;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;

public final class ExecutorsUtil {
    private static final ExecutorUtilDelegateExtensionPointManager EXTENSION_POINT_MANAGER = new ExecutorUtilDelegateExtensionPointManager();
    private static final ISingleThreadedExecutor EXECUTOR = (ISingleThreadedExecutor)((Object)Executors.getSharedExecutor("org.eclipse.tcf.te.runtime.concurrent.executors.singleThreaded"));
    private static final ISingleThreadedExecutor UI_EXECUTOR;

    static {
        Assert.isNotNull((Object)EXECUTOR);
        UI_EXECUTOR = (ISingleThreadedExecutor)((Object)Executors.getSharedExecutor("org.eclipse.tcf.te.ui.executors.SWTDisplay"));
    }

    public static void shutdown() {
        if (EXECUTOR instanceof ExecutorService) {
            ((ExecutorService)((Object)EXECUTOR)).shutdown();
        }
        if (UI_EXECUTOR instanceof ExecutorService) {
            ((ExecutorService)((Object)UI_EXECUTOR)).shutdown();
        }
    }

    public static boolean isExecutorThread() {
        return EXECUTOR != null ? EXECUTOR.isExecutorThread() : false;
    }

    public static boolean isUIExecutorThread() {
        return UI_EXECUTOR != null ? UI_EXECUTOR.isExecutorThread() : false;
    }

    public static void execute(Runnable runnable) {
        if (runnable != null) {
            if (EXECUTOR instanceof ExecutorService) {
                if (!((ExecutorService)((Object)EXECUTOR)).isShutdown() && !((ExecutorService)((Object)EXECUTOR)).isTerminated()) {
                    EXECUTOR.execute(runnable);
                }
            } else {
                EXECUTOR.execute(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWait(final Runnable runnable) {
        Assert.isTrue((!EXECUTOR.isExecutorThread() ? 1 : 0) != 0);
        if (runnable == null) {
            return;
        }
        final AtomicBoolean invoked = new AtomicBoolean(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    invoked.set(true);
                    Runnable runnable2 = runnable;
                    synchronized (runnable2) {
                        runnable.notifyAll();
                    }
                    throw throwable;
                }
                invoked.set(true);
                Runnable runnable3 = runnable;
                synchronized (runnable3) {
                    runnable.notifyAll();
                }
            }
        };
        if (EXECUTOR instanceof ExecutorService) {
            if (!((ExecutorService)((Object)EXECUTOR)).isShutdown() && !((ExecutorService)((Object)EXECUTOR)).isTerminated()) {
                EXECUTOR.execute(r);
            }
        } else {
            EXECUTOR.execute(r);
        }
        Runnable runnable2 = runnable;
        synchronized (runnable2) {
            try {
                while (!invoked.get()) {
                    runnable.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void executeInUI(Runnable runnable) {
        if (runnable != null) {
            if (UI_EXECUTOR instanceof ExecutorService) {
                if (!((ExecutorService)((Object)UI_EXECUTOR)).isShutdown() && !((ExecutorService)((Object)UI_EXECUTOR)).isTerminated()) {
                    UI_EXECUTOR.execute(runnable);
                }
            } else if (UI_EXECUTOR != null) {
                UI_EXECUTOR.execute(runnable);
            }
        }
    }

    public static void executeInUIWait(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        final AtomicBoolean invoked = new AtomicBoolean(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    invoked.set(true);
                }
            }
        };
        if (UI_EXECUTOR instanceof ExecutorService) {
            if (!((ExecutorService)((Object)UI_EXECUTOR)).isShutdown() && !((ExecutorService)((Object)UI_EXECUTOR)).isTerminated()) {
                UI_EXECUTOR.execute(r);
            }
        } else if (UI_EXECUTOR != null) {
            UI_EXECUTOR.execute(r);
        } else {
            invoked.set(true);
        }
        ExecutorsUtil.waitAndExecute(0L, new IConditionTester(){

            public boolean isConditionFulfilled() {
                return invoked.get();
            }

            public void cleanup() {
            }
        });
    }

    public static boolean waitAndExecute(long timeout, IConditionTester conditionTester) {
        if (conditionTester == null && timeout == 0L) {
            return true;
        }
        boolean exitReason = true;
        IExecutorUtilDelegate lastDelegate = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (conditionTester != null && conditionTester.isConditionFulfilled()) {
                exitReason = false;
                break;
            }
            if (timeout != 0L && System.currentTimeMillis() - startTime >= timeout) break;
            if (ExecutorsUtil.isExecutorThread()) {
                if (EXECUTOR instanceof INestableExecutor) {
                    ((INestableExecutor)((Object)EXECUTOR)).readAndExecute();
                    Thread.yield();
                    continue;
                }
                throw new IllegalStateException("waitAndExecute called from within a non-nestable executor service!");
            }
            if (ExecutorsUtil.isUIExecutorThread()) {
                if (UI_EXECUTOR instanceof INestableExecutor) {
                    ((INestableExecutor)((Object)UI_EXECUTOR)).readAndExecute();
                    Thread.yield();
                    continue;
                }
                throw new IllegalStateException("waitAndExecute called from within a non-nestable UI executor service!");
            }
            boolean foundHandlingDelegate = false;
            if (lastDelegate == null) {
                IExecutorUtilDelegate[] delegates;
                IExecutorUtilDelegate[] iExecutorUtilDelegateArray = delegates = EXTENSION_POINT_MANAGER.getExecutorUtilDelegates();
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    IExecutorUtilDelegate delegate = iExecutorUtilDelegateArray[n2];
                    if (delegate.isHandledExecutorThread()) {
                        foundHandlingDelegate = true;
                        lastDelegate = delegate;
                        delegate.readAndDispatch();
                        break;
                    }
                    ++n2;
                }
            } else {
                foundHandlingDelegate = true;
                lastDelegate.readAndDispatch();
            }
            if (foundHandlingDelegate) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (conditionTester != null) {
            conditionTester.cleanup();
        }
        return exitReason;
    }

    protected static class ExecutorUtilDelegateExtensionPointManager
    extends AbstractExtensionPointManager<IExecutorUtilDelegate> {
        protected ExecutorUtilDelegateExtensionPointManager() {
        }

        protected String getExtensionPointId() {
            return "org.eclipse.tcf.te.runtime.concurrent.executorUtilDelegates";
        }

        protected String getConfigurationElementName() {
            return "executorUtilDelegate";
        }

        public IExecutorUtilDelegate[] getExecutorUtilDelegates() {
            ArrayList<IExecutorUtilDelegate> contributions = new ArrayList<IExecutorUtilDelegate>();
            Collection proxies = this.getExtensions().values();
            for (ExecutableExtensionProxy proxy : proxies) {
                if (proxy.getInstance() == null || contributions.contains(proxy.getInstance())) continue;
                contributions.add((IExecutorUtilDelegate)proxy.getInstance());
            }
            return contributions.toArray(new IExecutorUtilDelegate[contributions.size()]);
        }

        public IExecutorUtilDelegate getExecutorUtilDelegate(String id, boolean newInstance) {
            Assert.isNotNull((Object)id);
            IExecutorUtilDelegate executorUtilDelegate = null;
            if (this.getExtensions().containsKey(id)) {
                ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
                executorUtilDelegate = newInstance ? (IExecutorUtilDelegate)proxy.newInstance() : (IExecutorUtilDelegate)proxy.getInstance();
            }
            return executorUtilDelegate;
        }
    }
}

