/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.debug.ui.ITCFLaunchContext;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.TCFLaunchContext;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TCFMainTab
extends AbstractLaunchConfigurationTab {
    private static final String LAUNCHING_PREFERENCE_PAGE_ID = "org.eclipse.debug.ui.LaunchingPreferencePage";
    private Text project_text;
    private Text local_program_text;
    private Text remote_program_text;
    private Text working_dir_text;
    private Button disable_build;
    private Button workspace_build;
    private Button default_dir_button;
    private Button attach_children_button;
    private Button stop_at_entry_button;
    private Button stop_at_main_button;
    private Button disconnect_on_ctx_exit;
    private Button terminal_button;
    private Button filter_button;
    private Combo build_config_combo;
    private Link workpsace_link;
    private Exception init_error;

    protected boolean isLocal() {
        return false;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createHeader(comp);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp);
        this.createBuildGroup(comp);
        this.createApplicationGroup(comp);
        this.createWorkingDirGroup(comp);
        this.createVerticalSpacer(comp, 1);
        this.createOptionButtons(comp, 1);
    }

    private void createHeader(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Launching an application requires a target that supports Processes service");
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
    }

    private void createProjectGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Project");
        Label label = new Label((Composite)group, 0);
        label.setText("Project Name:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.project_text = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.project_text.setLayoutData((Object)gd);
        this.project_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateBuildConfigCombo(false, null);
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button project_button = this.createPushButton((Composite)group, "Browse...", null);
        project_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleProjectButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createBuildGroup(Composite parent) {
        final Shell shell = parent.getShell();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Build (if required) before launching");
        this.createBuildConfigCombo((Composite)group, layout.numColumns);
        this.disable_build = new Button((Composite)group, 16);
        this.disable_build.setText("Disable auto build");
        this.disable_build.setToolTipText("Requires manually building project before launching");
        this.disable_build.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.workspace_build = new Button((Composite)group, 16);
        this.workspace_build.setText("Use workspace settings");
        this.workspace_build.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.workpsace_link = new Link((Composite)group, 0);
        this.workpsace_link.setText("<a>Configure Workspace Settings...</a>");
        this.workpsace_link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)TCFMainTab.LAUNCHING_PREFERENCE_PAGE_ID, null, null).open();
            }
        });
    }

    protected void createBuildConfigCombo(Composite parent, int colspan) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText("Build configuration:");
        this.build_config_combo = new Combo(comp, 12);
        this.build_config_combo.setLayoutData((Object)new GridData(768));
        this.build_config_combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createApplicationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Application");
        this.createLocalExeFileGroup((Composite)group);
        if (!this.isLocal()) {
            this.createRemoteExeFileGroup((Composite)group);
        }
    }

    private void createLocalExeFileGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label program_label = new Label(comp, 0);
        if (this.isLocal()) {
            program_label.setText("Application File Path:");
        } else {
            program_label.setText("Local File Path:");
        }
        gd = new GridData();
        gd.horizontalSpan = 3;
        program_label.setLayoutData((Object)gd);
        this.local_program_text = new Text(comp, 2052);
        this.local_program_text.setLayoutData((Object)new GridData(768));
        this.local_program_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button search_button = this.createPushButton(comp, "Search...", null);
        search_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleSearchButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse_button = this.createPushButton(comp, "Browse...", null);
        browse_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.handleBinaryBrowseButtonSelected();
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRemoteExeFileGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label program_label = new Label(comp, 0);
        program_label.setText("Remote File Path:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        program_label.setLayoutData((Object)gd);
        this.remote_program_text = new Text(comp, 2052);
        this.remote_program_text.setLayoutData((Object)new GridData(768));
        this.remote_program_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createWorkingDirGroup(Composite comp) {
        Group group = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Working directory");
        this.working_dir_text = new Text((Composite)group, 2052);
        this.working_dir_text.setLayoutData((Object)new GridData(768));
        this.working_dir_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.default_dir_button = new Button((Composite)group, 32);
        this.default_dir_button.setText("Use default");
        this.default_dir_button.setLayoutData((Object)new GridData(4, 1, true, false));
        this.default_dir_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createOptionButtons(Composite parent, int col_span) {
        Composite composite = new Composite(parent, 0);
        GridLayout terminal_layout = new GridLayout();
        terminal_layout.numColumns = 1;
        terminal_layout.marginHeight = 0;
        terminal_layout.marginWidth = 0;
        composite.setLayout((Layout)terminal_layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = col_span;
        composite.setLayoutData((Object)gd);
        this.attach_children_button = this.createCheckButton(composite, "Auto-attach process children");
        this.attach_children_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.attach_children_button.setEnabled(true);
        this.stop_at_entry_button = this.createCheckButton(composite, "Stop at program entry");
        this.stop_at_entry_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.stop_at_entry_button.setEnabled(true);
        this.stop_at_main_button = this.createCheckButton(composite, "Stop at 'main'");
        this.stop_at_main_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.stop_at_main_button.setEnabled(true);
        this.disconnect_on_ctx_exit = this.createCheckButton(composite, "Disconnect when last debug context exits");
        this.disconnect_on_ctx_exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.disconnect_on_ctx_exit.setEnabled(true);
        this.terminal_button = this.createCheckButton(composite, "Use pseudo-terminal for process standard I/O");
        this.terminal_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.terminal_button.setEnabled(true);
        this.filter_button = this.createCheckButton(composite, "Hide debug contexts started by other debug sessions");
        this.filter_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.filter_button.setEnabled(true);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.working_dir_text.setEnabled(!this.default_dir_button.getSelection());
    }

    protected void updateBuildConfigCombo(boolean auto, String selection) {
        Map<String, String> map;
        ITCFLaunchContext launch_context;
        int selection_index = auto ? 1 : 0;
        this.build_config_combo.removeAll();
        this.build_config_combo.add("Use Active");
        this.build_config_combo.add("Select Automatically");
        IProject project = this.getProject();
        if (project != null && (launch_context = TCFLaunchContext.getLaunchContext(project)) != null && (map = launch_context.getBuildConfigIDs(project)) != null) {
            int cnt = 2;
            for (String id : map.keySet()) {
                this.build_config_combo.add(map.get(id));
                if (id.equals(selection)) {
                    selection_index = cnt;
                }
                this.build_config_combo.setData(Integer.toString(cnt++), (Object)id);
            }
        }
        this.build_config_combo.select(selection_index);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            this.project_text.setText(config.getAttribute("org.eclipse.tcf.debug.ProjectName", ""));
            boolean auto = config.getAttribute("org.eclipse.tcf.debug.ProjectBuildConfigAuto", false);
            this.updateBuildConfigCombo(auto, config.getAttribute("org.eclipse.tcf.debug.ProjectBuildConfigID", null));
            int build = 0;
            build = config.getAttribute("org.eclipse.tcf.debug.BuildBeforeLaunch", build);
            this.disable_build.setSelection(build == 1);
            this.workspace_build.setSelection(build == 0);
            this.local_program_text.setText(config.getAttribute("org.eclipse.tcf.debug.LocalProgramFile", ""));
            if (this.remote_program_text != null) {
                this.remote_program_text.setText(config.getAttribute("org.eclipse.tcf.debug.ProgramFile", ""));
            }
            this.working_dir_text.setText(config.getAttribute("org.eclipse.tcf.debug.WorkingDirectory", ""));
            this.default_dir_button.setSelection(!config.hasAttribute("org.eclipse.tcf.debug.WorkingDirectory"));
            this.attach_children_button.setSelection(config.getAttribute("org.eclipse.tcf.debug.AttachChildren", true));
            this.stop_at_entry_button.setSelection(config.getAttribute("org.eclipse.tcf.debug.StopAtEntry", true));
            this.stop_at_main_button.setSelection(config.getAttribute("org.eclipse.tcf.debug.StopAtMain", true));
            this.disconnect_on_ctx_exit.setSelection(config.getAttribute("org.eclipse.tcf.debug.DisconnectOnCtxExit", true));
            this.terminal_button.setSelection(config.getAttribute("org.eclipse.tcf.debug.UseTerminal", true));
            this.filter_button.setSelection(config.getAttribute("org.eclipse.tcf.debug.UseContextFilter", true));
            this.working_dir_text.setEnabled(!this.default_dir_button.getSelection());
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    private IProject getProject() {
        String name = this.project_text.getText().trim();
        if (name.length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.tcf.debug.ProjectName", this.project_text.getText());
        int config_index = this.build_config_combo.getSelectionIndex();
        if (config_index == 0) {
            config.removeAttribute("org.eclipse.tcf.debug.ProjectBuildConfigID");
            config.removeAttribute("org.eclipse.tcf.debug.ProjectBuildConfigAuto");
        } else if (config_index == 1) {
            config.removeAttribute("org.eclipse.tcf.debug.ProjectBuildConfigID");
            config.setAttribute("org.eclipse.tcf.debug.ProjectBuildConfigAuto", true);
        } else {
            String config_id = (String)this.build_config_combo.getData(Integer.toString(config_index));
            config.setAttribute("org.eclipse.tcf.debug.ProjectBuildConfigID", config_id);
            config.removeAttribute("org.eclipse.tcf.debug.ProjectBuildConfigAuto");
        }
        int build = 0;
        if (this.disable_build.getSelection()) {
            build = 1;
        }
        config.setAttribute("org.eclipse.tcf.debug.BuildBeforeLaunch", build);
        config.setAttribute("org.eclipse.tcf.debug.LocalProgramFile", this.local_program_text.getText());
        if (this.isLocal()) {
            config.removeAttribute("org.eclipse.tcf.debug.PeerID");
            config.setAttribute("org.eclipse.tcf.debug.RunLocalServer", false);
            config.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", true);
            config.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", true);
            config.removeAttribute("org.eclipse.tcf.debug.ProgramFile");
        } else {
            config.setAttribute("org.eclipse.tcf.debug.ProgramFile", this.remote_program_text.getText());
        }
        if (this.default_dir_button.getSelection()) {
            config.removeAttribute("org.eclipse.tcf.debug.WorkingDirectory");
        } else {
            config.setAttribute("org.eclipse.tcf.debug.WorkingDirectory", this.working_dir_text.getText());
        }
        config.setAttribute("org.eclipse.tcf.debug.AttachChildren", this.attach_children_button.getSelection());
        config.setAttribute("org.eclipse.tcf.debug.StopAtEntry", this.stop_at_entry_button.getSelection());
        config.setAttribute("org.eclipse.tcf.debug.StopAtMain", this.stop_at_main_button.getSelection());
        config.setAttribute("org.eclipse.tcf.debug.DisconnectOnCtxExit", this.disconnect_on_ctx_exit.getSelection());
        config.setAttribute("org.eclipse.tcf.debug.UseTerminal", this.terminal_button.getSelection());
        if (this.filter_button.getSelection()) {
            config.removeAttribute("org.eclipse.tcf.debug.UseContextFilter");
        } else {
            config.setAttribute("org.eclipse.tcf.debug.UseContextFilter", false);
        }
    }

    private void handleSearchButtonSelected() {
        IProject project = this.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Project required", (String)"Enter project before searching for program");
            return;
        }
        ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(project);
        if (launch_context == null) {
            return;
        }
        String path = launch_context.chooseBinary(this.getShell(), project);
        if (path != null) {
            this.local_program_text.setText(path);
        }
    }

    private void handleBinaryBrowseButtonSelected() {
        FileDialog file_dialog = new FileDialog(this.getShell(), 0);
        file_dialog.setFileName(this.local_program_text.getText());
        String path = file_dialog.open();
        if (path != null) {
            this.local_program_text.setText(path);
        }
    }

    private void handleProjectButtonSelected() {
        try {
            IProject project = this.chooseProject();
            if (project == null) {
                return;
            }
            this.project_text.setText(project.getName());
        }
        catch (Exception e) {
            Activator.log("Cannot get project description", e);
        }
    }

    private IProject chooseProject() {
        try {
            Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            LabelProvider label_provider = new LabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return "";
                    }
                    return ((IProject)element).getName();
                }
            };
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)label_provider);
            dialog.setTitle("Project Selection");
            dialog.setMessage("Choose project to constrain search for program");
            dialog.setElements(projects);
            IProject cProject = this.getProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (IProject)dialog.getFirstResult();
            }
        }
        catch (Exception e) {
            Activator.log("Cannot show project list dialog", e);
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration config) {
        String remote_name;
        String local_name;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        String project_name = this.project_text.getText().trim();
        if (project_name.length() != 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(project_name);
            if (!project.exists()) {
                this.setErrorMessage("Project does not exist");
                return false;
            }
            if (!project.isOpen()) {
                this.setErrorMessage("Project must be opened");
                return false;
            }
        }
        if ((local_name = this.local_program_text.getText().trim()).equals(".") || local_name.equals("..")) {
            this.setErrorMessage("Invalid local program name");
            return false;
        }
        if (this.remote_program_text != null && ((remote_name = this.remote_program_text.getText().trim()).equals(".") || remote_name.equals(".."))) {
            this.setErrorMessage("Invalid remote program name");
            return false;
        }
        if (local_name.length() > 0) {
            IProject project = this.getProject();
            Path program_path = new Path(local_name);
            if (!program_path.isAbsolute()) {
                if (project == null) {
                    File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                    File file = new File(ws, local_name);
                    if (!file.exists()) {
                        this.setErrorMessage("File not found: " + file);
                        return false;
                    }
                    if (file.isDirectory()) {
                        this.setErrorMessage("Program path is directory name: " + file);
                        return false;
                    }
                    program_path = new Path(file.getAbsolutePath());
                } else {
                    if (!project.getFile(local_name).exists()) {
                        this.setErrorMessage("Program does not exist");
                        return false;
                    }
                    program_path = project.getFile(local_name).getLocation();
                }
            } else {
                File file = program_path.toFile();
                if (!file.exists()) {
                    this.setErrorMessage("Program file does not exist");
                    return false;
                }
                if (file.isDirectory()) {
                    this.setErrorMessage("Program path is directory name");
                    return false;
                }
            }
            if (project != null) {
                try {
                    ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(project);
                    if (launch_context != null && !launch_context.isBinary(project, (IPath)program_path)) {
                        this.setErrorMessage("Program is not a recongnized executable");
                        return false;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    this.setErrorMessage(e.getLocalizedMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.tcf.debug.ProjectName", "");
        config.setAttribute("org.eclipse.tcf.debug.AttachChildren", true);
        config.setAttribute("org.eclipse.tcf.debug.StopAtEntry", true);
        config.setAttribute("org.eclipse.tcf.debug.StopAtMain", true);
        config.setAttribute("org.eclipse.tcf.debug.DisconnectOnCtxExit", true);
        config.setAttribute("org.eclipse.tcf.debug.UseTerminal", true);
        config.removeAttribute("org.eclipse.tcf.debug.UseContextFilter");
        config.removeAttribute("org.eclipse.tcf.debug.WorkingDirectory");
        ITCFLaunchContext launch_context = TCFLaunchContext.getLaunchContext(null);
        if (launch_context != null) {
            launch_context.setDefaults(this.getLaunchConfigurationDialog(), config);
        }
    }

    public String getName() {
        return "Application";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/application_tab");
    }
}

