/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class RegisterVectorDisplayMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final int MAX_REG_REPRESENTATIONS = 100;
    private IServiceLocator service_locator;
    private ArrayList<String> elements;
    private Map<String, Map<String, String>> modes;

    public void initialize(IServiceLocator service_locator) {
        this.service_locator = service_locator;
    }

    private Object[] getSelectedRegisters() {
        ISelection selection;
        ISelectionService service = (ISelectionService)this.service_locator.getService(ISelectionService.class);
        if (service != null && (selection = service.getSelection()) instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toArray();
        }
        return new Object[0];
    }

    protected IContributionItem[] getContributionItems() {
        IWorkbenchPart part = this.getPart();
        if (part == null) {
            return null;
        }
        final Object[] selection = this.getSelectedRegisters();
        TCFNode node = this.getRootNode(part);
        if (node == null) {
            return null;
        }
        if (!(node instanceof TCFNodeExecContext) && !(node instanceof TCFNodeStackFrame)) {
            return null;
        }
        try {
            new TCFTask<Boolean>(node.getChannel()){

                public void run() {
                    RegisterVectorDisplayMenu.this.modes = new LinkedHashMap();
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof TCFNodeRegister) {
                            TCFNodeRegister reg = (TCFNodeRegister)obj;
                            AtomicBoolean grp = new AtomicBoolean();
                            if (!reg.isRepresentationGroup(grp, (Runnable)((Object)this))) {
                                return;
                            }
                            if (grp.get()) {
                                TCFChildren children = reg.getChildren();
                                if (!children.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                TCFNode[] tCFNodeArray = children.toArray();
                                int n3 = tCFNodeArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    TCFNode child_node = tCFNodeArray[n4];
                                    TCFNodeRegister child_reg = (TCFNodeRegister)child_node;
                                    if (!child_reg.getContext().validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    IRegisters.RegistersContext child_ctx = (IRegisters.RegistersContext)child_reg.getContext().getData();
                                    String reg_name = child_ctx.getName();
                                    if (reg_name.matches("w[0-9]+")) {
                                        String mode = String.valueOf(reg_name.substring(1, reg_name.length())) + "bits";
                                        HashMap<String, String> map = (HashMap<String, String>)RegisterVectorDisplayMenu.this.modes.get(mode);
                                        if (map == null) {
                                            map = new HashMap<String, String>();
                                            RegisterVectorDisplayMenu.this.modes.put(mode, map);
                                        }
                                        map.put(reg.getID(), child_ctx.getID());
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                    Iterator i = RegisterVectorDisplayMenu.this.modes.values().iterator();
                    block2: while (i.hasNext()) {
                        Map map = (Map)i.next();
                        Object[] objectArray2 = selection;
                        int n5 = selection.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object obj = objectArray2[n6];
                            if (obj instanceof TCFNodeRegister && !map.containsKey(((TCFNodeRegister)obj).getID())) {
                                i.remove();
                                continue block2;
                            }
                            ++n6;
                        }
                    }
                    RegisterVectorDisplayMenu.this.elements = new ArrayList(RegisterVectorDisplayMenu.this.modes.keySet());
                    RegisterVectorDisplayMenu.this.elements.add(0, RegisterVectorDisplayMenu.this.elements.size() == 0 ? "No vector display options available" : "none");
                    this.done(Boolean.TRUE);
                }
            }.get();
        }
        catch (Exception x) {
            return null;
        }
        IContributionItem[] items = new IContributionItem[this.elements.size()];
        int i = 0;
        while (i < items.length) {
            final int n = i;
            items[i] = new ContributionItem(){

                public void fill(Menu menu, int index) {
                    final MenuItem item = new MenuItem(menu, RegisterVectorDisplayMenu.this.elements.size() <= 1 ? 0 : 16);
                    item.setText((String)RegisterVectorDisplayMenu.this.elements.get(n));
                    item.setSelection(RegisterVectorDisplayMenu.this.getRepresentation() == n);
                    item.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (item.getSelection()) {
                                RegisterVectorDisplayMenu.this.setRepresentation(n);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
            };
            ++i;
        }
        return items;
    }

    private IWorkbenchPart getPart() {
        IPartService partService = (IPartService)this.service_locator.getService(IPartService.class);
        if (partService != null) {
            return partService.getActivePart();
        }
        return null;
    }

    private TCFNode getRootNode(IWorkbenchPart part) {
        Object input;
        IWorkbenchPartSite site = part.getSite();
        if (site == null || "org.eclipse.debug.ui.DebugView".equals(site.getId())) {
            return null;
        }
        if (part instanceof IDebugView && (input = ((IDebugView)part).getViewer().getInput()) instanceof TCFNode) {
            return (TCFNode)input;
        }
        return null;
    }

    private ITreeModelViewer getViewer() {
        IWorkbenchPart part = this.getPart();
        if (part instanceof IDebugView) {
            return (ITreeModelViewer)((IDebugView)part).getViewer();
        }
        return null;
    }

    private int getRepresentation() {
        IWorkbenchPart part = this.getPart();
        if (part == null) {
            return 0;
        }
        TCFNode node = null;
        Object[] objectArray = this.getSelectedRegisters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof TCFNodeRegister) {
                node = (TCFNodeRegister)obj;
                break;
            }
            ++n2;
        }
        if (node == null) {
            return 0;
        }
        final String id = node.getID();
        final IPresentationContext ctx = this.getViewer().getPresentationContext();
        return (Integer)new TCFTask<Integer>(node.getChannel()){

            public void run() {
                String rep_id;
                Map representation = (Map)ctx.getProperty("PROPERTY_REGISTER_REPRESENTATION");
                if (representation != null && (rep_id = (String)representation.get(id)) != null) {
                    for (Map.Entry e : RegisterVectorDisplayMenu.this.modes.entrySet()) {
                        if (!rep_id.equals(((Map)e.getValue()).get(id))) continue;
                        this.done(RegisterVectorDisplayMenu.this.elements.indexOf(e.getKey()));
                        return;
                    }
                }
                this.done(0);
            }
        }.getE();
    }

    private void setRepresentation(final int n) {
        IWorkbenchPart part = this.getPart();
        if (part == null) {
            return;
        }
        final TCFNode node = this.getRootNode(part);
        if (node == null) {
            return;
        }
        final Object[] selection = this.getSelectedRegisters();
        ITreeModelViewer viewer = this.getViewer();
        final IPresentationContext ctx = viewer.getPresentationContext();
        new TCFTask<Object>(node.getChannel()){

            public void run() {
                Map representation = (Map)ctx.getProperty("PROPERTY_REGISTER_REPRESENTATION");
                if (representation == null) {
                    representation = new LinkedHashMap<String, String>(){

                        @Override
                        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                            return this.size() > 100;
                        }
                    };
                    ctx.setProperty("PROPERTY_REGISTER_REPRESENTATION", (Object)representation);
                }
                Map map = (Map)RegisterVectorDisplayMenu.this.modes.get(RegisterVectorDisplayMenu.this.elements.get(n));
                TCFModelProxy[] proxies = node.getModel().getModelProxies(ctx);
                Object[] objectArray = selection;
                int n4 = selection.length;
                int n2 = 0;
                while (n2 < n4) {
                    Object obj = objectArray[n2];
                    if (obj instanceof TCFNodeRegister) {
                        String rep_id;
                        TCFNodeRegister reg = (TCFNodeRegister)obj;
                        String id = reg.getID();
                        String string = rep_id = map != null ? (String)map.get(id) : null;
                        if (rep_id == null) {
                            representation.remove(id);
                        } else {
                            representation.put(id, rep_id);
                        }
                        int i = 0;
                        while (i < proxies.length) {
                            proxies[i].addDelta(reg, 1024);
                            TCFNode n3 = node.getModel().getNode(rep_id);
                            if (n3 != null) {
                                proxies[i].expand(n3);
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
                this.done(null);
            }
        };
    }
}

