/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.locator.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerModelStep;

public class WaitForReadyStep
extends AbstractPeerModelStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        final ILocatorModelRefreshService service = Model.getModel().getService(ILocatorModelRefreshService.class);
        if (service != null) {
            Protocol.invokeLater((Runnable)new Runnable(){
                final Runnable thisRunnable = this;
                int refreshCount = 0;

                @Override
                public void run() {
                    if (monitor.isCanceled()) {
                        callback.done((Object)WaitForReadyStep.this, Status.CANCEL_STATUS);
                    } else if (this.refreshCount >= WaitForReadyStep.this.getTotalWork(context, data)) {
                        callback.done((Object)WaitForReadyStep.this, StatusHelper.getStatus((Throwable)new TimeoutException(Messages.WaitForReadyStep_error_timeout)));
                    } else if (WaitForReadyStep.this.getActivePeerModelContext(context, data, fullQualifiedId).isProperty("state", 4)) {
                        service.refresh((ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                ++refreshCount;
                                ProgressHelper.worked((IProgressMonitor)monitor, (int)1);
                                Protocol.invokeLater((long)(refreshCount < 20 ? 500 : 1000), (Runnable)thisRunnable);
                            }
                        });
                    } else {
                        int state = WaitForReadyStep.this.getActivePeerModelContext(context, data, fullQualifiedId).getIntProperty("state");
                        if (state == 1 || state == 0) {
                            callback.done((Object)WaitForReadyStep.this, Status.OK_STATUS);
                        } else {
                            callback.done((Object)WaitForReadyStep.this, StatusHelper.getStatus((Throwable)new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.WaitForReadyStep_error_state))));
                        }
                    }
                }
            });
        } else {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    public int getTotalWork(IStepContext context, IPropertiesContainer data) {
        return 100;
    }

    public void rollback(IStepContext context, IPropertiesContainer data, IStatus status, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                Tcf.getChannelManager().shutdown(peer);
            }
        });
        super.rollback(context, data, status, fullQualifiedId, monitor, callback);
    }
}

