/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.listener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;

public class ChannelStateChangeListener
implements IChannelStateChangeListener {
    private final ILocatorModel model;

    public ChannelStateChangeListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    public void stateChanged(IChannel channel, int state) {
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelStateChangeListener")) {
            CoreBundleActivator.getTraceHandler().trace("ChannelStateChangeListener.stateChanged( " + channel + ", " + (state == 1 ? "OPEN" : "CLOSED") + " )", "trace/channelStateChangeListener", (Object)this);
        }
        switch (state) {
            case 1: {
                IPeerModel node;
                IPeer peer = channel.getRemotePeer();
                if (peer == null || peer.getID() == null || (node = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID())) == null) break;
                int counter = node.getIntProperty("channelRefCounter.silent");
                if (counter < 0) {
                    counter = 0;
                }
                node.setProperty("channelRefCounter.silent", ++counter);
                if (counter <= 0) break;
                node.setProperty("state", 1);
                break;
            }
            case 2: {
                IPeerModel node;
                IPeer peer = channel.getRemotePeer();
                if (peer == null || peer.getID() == null || (node = this.model.getService(ILocatorModelLookupService.class).lkupPeerModelById(peer.getID())) == null) break;
                int counter = node.getIntProperty("channelRefCounter.silent");
                if (--counter < 0) {
                    counter = 0;
                }
                node.setProperty("channelRefCounter.silent", counter);
                if (counter != 0 || !node.isProperty("state", 1)) break;
                node.setProperty("state", 0);
            }
        }
    }
}

