/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.adapters;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.adapters.ModelNodePersistableURIProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;

public class PeerPersistableURIProvider
extends ModelNodePersistableURIProvider {
    private IPeer getPeer(Object context) {
        IPeer peer = null;
        if (context instanceof IPeer) {
            peer = (IPeer)context;
        } else if (context instanceof IPeerModel) {
            peer = ((IPeerModel)context).getPeer();
        } else if (context instanceof IPeerModelProvider) {
            peer = ((IPeerModelProvider)context).getPeerModel().getPeer();
        }
        return peer;
    }

    public URI getURI(Object context) {
        Assert.isNotNull((Object)context);
        URI uri = null;
        final IPeer peer = this.getPeer(context);
        if (peer != null) {
            final AtomicReference nodeURI = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String value = (String)peer.getAttributes().get("URI.transient");
                    if (value != null && !"".equals(value.trim())) {
                        nodeURI.set(URI.create(value.trim()));
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            if (nodeURI.get() != null) {
                uri = (URI)nodeURI.get();
            }
            if (uri == null) {
                String name = peer.getName();
                if (name == null) {
                    name = peer.getID();
                }
                name = this.makeValidFileSystemName(name);
                uri = this.getRoot().append(name).toFile().toURI();
            }
        }
        return uri;
    }

    public IPath getRoot() {
        return ModelLocationUtil.getStaticPeersRootLocation();
    }
}

