/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.actions;

import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.Protocol;

public abstract class TCFAction
implements Runnable {
    protected final TCFLaunch launch;
    protected final String ctx_id;
    protected boolean aborted;

    public TCFAction(TCFLaunch launch, String ctx_id) {
        assert (Protocol.isDispatchThread());
        this.launch = launch;
        this.ctx_id = ctx_id;
        launch.addContextAction(this);
    }

    public void abort() {
        this.aborted = true;
    }

    public String getContextID() {
        return this.ctx_id;
    }

    public int getPriority() {
        return 0;
    }

    public void setActionResult(String id, String result) {
        this.launch.setContextActionResult(id, result);
    }

    public void done() {
        assert (Protocol.isDispatchThread());
        this.launch.removeContextAction(this);
    }
}

