/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class IDSection
extends BaseTitledSection {
    ISysMonitor.SysMonitorContext context;
    private Text pidText;
    private Text ppidText;
    private Text ipidText;
    private Text ippidText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.pidText = this.createTextField(null, Messages.IDSection_ProcessID);
        this.ppidText = this.createTextField((Control)this.pidText, Messages.IDSection_ParentID);
        this.ipidText = this.createTextField((Control)this.ppidText, Messages.IDSection_InternalID);
        this.ippidText = this.createTextField((Control)this.ipidText, Messages.IDSection_InternalPPID);
    }

    protected void updateInput(IPeerModelProvider input) {
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        final IProcessContextNode node = (IProcessContextNode)input;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IDSection.this.context = node.getSysMonitorContext();
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void refresh() {
        SWTControlUtil.setText((Control)this.pidText, (String)(this.context != null && this.context.getPID() >= 0L ? Long.toString(this.context.getPID()) : ""));
        SWTControlUtil.setText((Control)this.ppidText, (String)(this.context != null && this.context.getPPID() >= 0L ? Long.toString(this.context.getPPID()) : ""));
        SWTControlUtil.setText((Control)this.ipidText, (String)(this.context != null && this.context.getID() != null ? this.context.getID() : ""));
        SWTControlUtil.setText((Control)this.ippidText, (String)(this.context != null && this.context.getParentID() != null ? this.context.getParentID() : ""));
        super.refresh();
    }

    protected String getText() {
        return Messages.IDSection_Title;
    }
}

