/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.job;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.stepper.Stepper;

public class StepperJob
extends Job {
    private final IStepContext stepContext;
    private final IPropertiesContainer data;
    private final String stepGroupId;
    private final String operation;
    private ICallback jobCallback = null;
    private boolean isFinished = false;
    private boolean isCanceled = false;
    private final boolean isCancelable;

    public StepperJob(String name, IStepContext stepContext, IPropertiesContainer data, String stepGroupId, String operation, boolean isCancelable) {
        super(name);
        IPropertiesAccessService service;
        StepperJob job;
        this.setPriority(10);
        Assert.isNotNull((Object)stepContext);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)stepGroupId);
        Assert.isNotNull((Object)operation);
        this.stepContext = stepContext;
        this.data = data;
        this.stepGroupId = stepGroupId;
        this.operation = operation;
        this.isCancelable = isCancelable;
        if (stepContext.getContextObject() instanceof ISchedulingRule) {
            this.setRule((ISchedulingRule)stepContext.getContextObject());
        }
        StepperJob stepperJob = job = (service = (IPropertiesAccessService)ServiceManager.getInstance().getService(stepContext.getContextObject(), IPropertiesAccessService.class)) != null ? (StepperJob)((Object)service.getProperty(stepContext.getContextObject(), String.valueOf(StepperJob.class.getName()) + "." + operation)) : null;
        if (service == null && stepContext.getContextObject() instanceof IPropertiesContainer) {
            job = (StepperJob)((Object)((IPropertiesContainer)stepContext.getContextObject()).getProperty(String.valueOf(StepperJob.class.getName()) + "." + operation));
        }
        Assert.isTrue((job == null ? 1 : 0) != 0);
        if (service != null) {
            service.setProperty(stepContext.getContextObject(), String.valueOf(StepperJob.class.getName()) + "." + operation, (Object)this);
        } else if (stepContext.getContextObject() instanceof IPropertiesContainer) {
            ((IPropertiesContainer)stepContext.getContextObject()).setProperty(String.valueOf(StepperJob.class.getName()) + "." + operation, (Object)this);
        }
    }

    public final void setJobCallback(ICallback callback) {
        this.jobCallback = callback;
    }

    public final ICallback getJobCallback() {
        return this.jobCallback;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    protected final IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block16: {
            if (!this.isCancelable) {
                monitor = new NotCancelableProgressMonitor(monitor);
            }
            Stepper stepper = new Stepper(this.getName());
            status = Status.OK_STATUS;
            try {
                try {
                    stepper.initialize(this.stepContext, this.stepGroupId, this.data, monitor);
                    stepper.execute();
                }
                catch (CoreException e) {
                    status = e.getStatus();
                    stepper.cleanup();
                    IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(this.stepContext.getContextObject(), IPropertiesAccessService.class);
                    if (service != null) {
                        service.setProperty(this.stepContext.getContextObject(), String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
                    } else if (this.stepContext.getContextObject() instanceof IPropertiesContainer) {
                        ((IPropertiesContainer)this.stepContext.getContextObject()).setProperty(String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                stepper.cleanup();
                IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(this.stepContext.getContextObject(), IPropertiesAccessService.class);
                if (service != null) {
                    service.setProperty(this.stepContext.getContextObject(), String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
                } else if (this.stepContext.getContextObject() instanceof IPropertiesContainer) {
                    ((IPropertiesContainer)this.stepContext.getContextObject()).setProperty(String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
                }
                throw throwable;
            }
            stepper.cleanup();
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(this.stepContext.getContextObject(), IPropertiesAccessService.class);
            if (service != null) {
                service.setProperty(this.stepContext.getContextObject(), String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
            } else if (this.stepContext.getContextObject() instanceof IPropertiesContainer) {
                ((IPropertiesContainer)this.stepContext.getContextObject()).setProperty(String.valueOf(StepperJob.class.getName()) + "." + this.operation, null);
            }
        }
        if (this.jobCallback != null) {
            this.jobCallback.done((Object)this, status);
        }
        this.isFinished = true;
        return status;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isCanceled() {
        return this.isCanceled && this.isCancelable;
    }

    protected void canceling() {
        if (this.isCancelable) {
            super.canceling();
            this.isCanceled = true;
        }
    }

    private class NotCancelableProgressMonitor
    implements IProgressMonitor {
        private final IProgressMonitor monitor;

        public NotCancelableProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        public void done() {
            this.monitor.done();
        }

        public void internalWorked(double work) {
            this.monitor.internalWorked(work);
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
            this.monitor.setCanceled(false);
        }

        public void setTaskName(String name) {
            this.monitor.setTaskName(name);
        }

        public void subTask(String name) {
            this.monitor.subTask(name);
        }

        public void worked(int work) {
            this.monitor.worked(work);
        }
    }
}

