/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IImportPersistenceService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.navigator.DelegatingLabelProvider;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.ui.progress.UIJob;

public class PeerImportWizardPage
extends WizardPage {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String OVERWRITE = "overwrite";
    private static final String OLD_PATH = "oldpath";
    CheckboxTableViewer fViewer;
    Text fLocationField;
    private Button fLocationButton;
    private Button fOverwrite;

    public PeerImportWizardPage() {
        super(Messages.PeerImportWizard_title);
        this.setTitle(Messages.PeerImportWizard_title);
        this.setMessage(Messages.PeerImportWizard_message);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createLocationGroup(composite);
        this.createPeersGroup(composite);
        if (this.getDialogSettings().get(OLD_PATH) != null) {
            this.fLocationField.setText(this.getDialogSettings().get(OLD_PATH));
        } else {
            this.fLocationField.setText(Platform.getLocation().toOSString());
        }
        this.setPageComplete(this.isComplete());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    private final void createPeersGroup(Composite parent) {
        Composite resourcesGroup = new Composite(parent, 0);
        resourcesGroup.setLayout((Layout)new GridLayout());
        resourcesGroup.setLayoutData((Object)new GridData(1808));
        resourcesGroup.setFont(parent.getFont());
        new Label(resourcesGroup, 0).setText(Messages.PeerImportWizardPage_peers_label);
        Table table = new Table(resourcesGroup, 2080);
        table.setLayoutData((Object)new GridData(1808));
        this.fViewer = new CheckboxTableViewer(table);
        this.fViewer.setContentProvider((IContentProvider)new ITreePathContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<IPeer> elements = new ArrayList<IPeer>();
                File[] candidates = ((IPath)inputElement).toFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        Path path = new Path(pathname.getAbsolutePath());
                        return path.getFileExtension() != null && path.getFileExtension().toLowerCase().equals("peer");
                    }
                });
                if (candidates != null && candidates.length > 0) {
                    File[] fileArray = candidates;
                    int n = candidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File candidate = fileArray[n2];
                        try {
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                            if (service != null) {
                                IPeer tempPeer = (IPeer)service.read(IPeer.class, candidate.getAbsoluteFile().toURI());
                                elements.add(tempPeer);
                            }
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                }
                return elements.toArray();
            }

            public Object[] getChildren(TreePath parentPath) {
                return null;
            }

            public boolean hasChildren(TreePath path) {
                return false;
            }

            public TreePath[] getParents(Object element) {
                return null;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider());
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PeerImportWizardPage.this.setPageComplete(PeerImportWizardPage.this.isComplete());
            }
        };
        this.fViewer.addCheckStateListener(checkListener);
        Composite buttonComposite = new Composite(resourcesGroup, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.PeerImportWizardPage_selectAll, false);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeerImportWizardPage.this.fViewer.setAllChecked(true);
                PeerImportWizardPage.this.setPageComplete(PeerImportWizardPage.this.isComplete());
            }
        });
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.PeerImportWizardPage_deselectAll, false);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeerImportWizardPage.this.fViewer.setAllChecked(false);
                PeerImportWizardPage.this.setPageComplete(PeerImportWizardPage.this.isComplete());
            }
        });
        new Label(resourcesGroup, 0);
        this.fOverwrite = new Button(resourcesGroup, 32);
        this.fOverwrite.setText(Messages.PeerImportWizardPage_overwrite_button);
        this.fOverwrite.setSelection(this.getDialogSettings().getBoolean(OVERWRITE));
    }

    private Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)id);
        button.setText(label);
        button.setFont(parent.getFont());
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    private void createLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        destinationSelectionGroup.setLayout((Layout)new GridLayout(3, false));
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(Messages.PeerImportWizardPage_destination_label);
        destinationLabel.setFont(font);
        this.fLocationField = new Text(destinationSelectionGroup, 2048);
        this.fLocationField.setFont(font);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 250;
        this.fLocationField.setLayoutData((Object)gd);
        this.fLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PeerImportWizardPage.this.fViewer.setInput((Object)new Path(PeerImportWizardPage.this.fLocationField.getText()));
            }
        });
        this.fLocationButton = this.createButton(destinationSelectionGroup, 18, Messages.PeerImportWizardPage_destination_button, false);
        this.fLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(PeerImportWizardPage.this.getContainer().getShell());
                dd.setText(Messages.PeerImportWizardPage_destination_label);
                String file = dd.open();
                if (file != null) {
                    Path path = new Path(file);
                    PeerImportWizardPage.this.fLocationField.setText(path.toOSString());
                    PeerImportWizardPage.this.setPageComplete(PeerImportWizardPage.this.isComplete());
                }
            }
        });
    }

    protected boolean isComplete() {
        Object[] elements = this.fViewer.getCheckedElements();
        boolean selected = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IPeer) {
                selected = true;
                break;
            }
            ++n2;
        }
        if (elements.length < 1 || !selected) {
            this.setErrorMessage(Messages.PeerImportWizardPage_peersMissing_error);
            return false;
        }
        String path = this.fLocationField.getText().trim();
        if (path.length() == 0) {
            this.setErrorMessage(Messages.PeerImportWizardPage_locationMissing_error);
            return false;
        }
        if (new File(path).isFile()) {
            this.setErrorMessage(Messages.PeerImportWizardPage_locationIsFile_error);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.PeerImportWizard_message);
        return true;
    }

    public boolean finish() {
        final Object[] configs = this.fViewer.getCheckedElements();
        boolean overwrite = this.fOverwrite.getSelection();
        String path = this.fLocationField.getText().trim();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(OVERWRITE, overwrite);
        settings.put(OLD_PATH, path);
        UIJob importjob = new UIJob(this.getContainer().getShell().getDisplay(), Messages.PeerImportWizard_title){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                final ILocatorModel model = Model.getModel();
                Object finalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                finalMonitor.beginTask(Messages.PeerImportWizard_title, configs.length);
                boolean toggleState = false;
                int toggleResult = -1;
                Object[] objectArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        block9: {
                            IURIPersistenceService service;
                            Object config;
                            block10: {
                                config = objectArray[n2];
                                if (!(config instanceof IPeer)) break block9;
                                final AtomicReference peerModel = new AtomicReference();
                                Protocol.invokeAndWait((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        peerModel.set(((ILocatorModelLookupService)model.getService(ILocatorModelLookupService.class)).lkupPeerModelById(((IPeer)config).getID()));
                                        if (peerModel.get() == null) {
                                            IPeerModel[] iPeerModelArray = model.getPeers();
                                            int n = iPeerModelArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String name;
                                                IPeerModel peer = iPeerModelArray[n2];
                                                if (peer.isStatic() && (name = peer.getPeer().getName()).equalsIgnoreCase(((IPeer)config).getName())) {
                                                    peerModel.set(peer);
                                                    break;
                                                }
                                                ++n2;
                                            }
                                        }
                                        if (peerModel.get() != null && !((IPeerModel)peerModel.get()).isStatic()) {
                                            peerModel.set(null);
                                        }
                                    }
                                });
                                service = (IURIPersistenceService)ServiceManager.getInstance().getService(IImportPersistenceService.class);
                                if (service == null) {
                                    service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                                }
                                if (peerModel.get() == null) break block10;
                                if (!toggleState || toggleResult < 0) {
                                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)PeerImportWizardPage.this.getShell(), null, (String)NLS.bind((String)Messages.PeerImportWizardPage_overwriteDialog_message, (Object)((IPeerModel)peerModel.get()).getName()), (String)Messages.PeerImportWizardPage_overwriteDialogToggle_message, (boolean)toggleState, null, null);
                                    toggleState = dialog.getToggleState();
                                    toggleResult = dialog.getReturnCode();
                                }
                                if (toggleResult != 2) break block11;
                                try {
                                    service.delete((Object)((IPeerModel)peerModel.get()).getPeer(), null);
                                }
                                catch (IOException iOException) {}
                            }
                            try {
                                URI uri = service.getURI(config);
                                File defaultFile = new File(uri.normalize());
                                File file = new Path(new File(uri.normalize()).toString()).addFileExtension("peer").toFile();
                                int i = 1;
                                while (file.exists()) {
                                    file = new Path(String.valueOf(defaultFile.toString()) + "_" + i).addFileExtension("peer").toFile();
                                    ++i;
                                }
                                service.write(config, file.toURI());
                            }
                            catch (IOException iOException) {}
                        }
                        finalMonitor.worked(1);
                    }
                    ++n2;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((ILocatorModelRefreshService)model.getService(ILocatorModelRefreshService.class)).refresh(null);
                    }
                });
                finalMonitor.done();
                return Status.OK_STATUS;
            }
        };
        importjob.schedule();
        return true;
    }
}

