/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            this.refresh(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                }
            });
        }
        return null;
    }

    public void refresh(ISelection selection, ICallback callback) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Runnable runnable;
            AsyncCallbackCollector.SimpleCollectorCallback innerCallback;
            ILocatorModel finModel;
            ILocatorModel model;
            ArrayList<ILocatorModel> locatorToRefresh = new ArrayList<ILocatorModel>();
            ArrayList<IPeerModel> peerToRefresh = new ArrayList<IPeerModel>();
            for (Object element : (IStructuredSelection)selection) {
                Assert.isTrue((boolean)(element instanceof IPeerModel));
                IPeerModel node = (IPeerModel)element;
                ILocatorModel model2 = (ILocatorModel)node.getAdapter(ILocatorModel.class);
                Assert.isNotNull((Object)model2);
                if (!locatorToRefresh.contains(model2)) {
                    locatorToRefresh.add(model2);
                }
                if (peerToRefresh.contains(node)) continue;
                peerToRefresh.add(node);
            }
            AsyncCallbackCollector collector = new AsyncCallbackCollector(callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
            Iterator iterator = locatorToRefresh.iterator();
            while (iterator.hasNext()) {
                finModel = model = (ILocatorModel)iterator.next();
                innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                runnable = new Runnable((ICallback)innerCallback){
                    private final /* synthetic */ ICallback val$innerCallback;
                    {
                        this.val$innerCallback = iCallback;
                    }

                    @Override
                    public void run() {
                        ((ILocatorModelRefreshService)finModel.getService(ILocatorModelRefreshService.class)).refresh((ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                val$innerCallback.done((Object)this, Status.OK_STATUS);
                            }
                        });
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
            iterator = peerToRefresh.iterator();
            while (iterator.hasNext()) {
                finModel = model = (IPeerModel)iterator.next();
                innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                runnable = new Runnable((IPeerModel)finModel, (ICallback)innerCallback){
                    private final /* synthetic */ IPeerModel val$finModel;
                    private final /* synthetic */ ICallback val$innerCallback;
                    {
                        this.val$finModel = iPeerModel;
                        this.val$innerCallback = iCallback;
                    }

                    @Override
                    public void run() {
                        new ScannerRunnable(null, this.val$finModel).run();
                        this.val$innerCallback.done((Object)this, Status.OK_STATUS);
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
            collector.initDone();
        } else {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }
}

