/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.services.contexts.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.listener.ModelAdapter;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.services.contexts.interfaces.IContextService;
import org.eclipse.tcf.te.tcf.services.contexts.internal.ContextServiceAdapter;

public class AdapterFactory
implements IAdapterFactory {
    Map<IPeer, IContextService> adapters = new HashMap<IPeer, IContextService>();
    private static final Class<?>[] CLASSES = new Class[]{IContextService.class};

    public AdapterFactory() {
        ModelAdapter listener = new ModelAdapter(){

            public void locatorModelChanged(ILocatorModel model, IPeerModel peer, boolean added) {
                IContextService adapter;
                if (peer != null && peer.getPeer() != null && !added && (adapter = AdapterFactory.this.adapters.remove(peer.getPeer())) instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }
        };
        Runnable runnable = new Runnable((IModelListener)listener){
            private final /* synthetic */ IModelListener val$listener;
            {
                this.val$listener = iModelListener;
            }

            @Override
            public void run() {
                Model.getModel().addListener(this.val$listener);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IPeer) {
            IContextService adapter = this.adapters.get(adaptableObject);
            if (adapter == null) {
                adapter = new ContextServiceAdapter((IPeer)adaptableObject);
                this.adapters.put((IPeer)adaptableObject, adapter);
            }
            return adapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

