/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.testers;

import java.io.File;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.ContentTypeHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class FSTreeNodePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver == null) {
            return false;
        }
        Assert.isTrue((boolean)(receiver instanceof FSTreeNode));
        FSTreeNode node = (FSTreeNode)receiver;
        if (property.equals("isFile")) {
            return node.isFile();
        }
        if (property.equals("isDirectory")) {
            return node.isDirectory();
        }
        if (property.equals("isBinaryFile")) {
            return ContentTypeHelper.isBinaryFile(node);
        }
        if (property.equals("isReadable")) {
            return node.isReadable();
        }
        if (property.equals("isWritable")) {
            return node.isWritable();
        }
        if (property.equals("isExecutable")) {
            return node.isExecutable();
        }
        if (property.equals("isRoot")) {
            return node.isRoot();
        }
        if (property.equals("isSystemRoot")) {
            return node.isSystemRoot();
        }
        if (property.equals("isWindows")) {
            return node.isWindowsNode();
        }
        if (property.equals("isReadOnly")) {
            return node.isReadOnly();
        }
        if (property.equals("isHidden")) {
            return node.isHidden();
        }
        if (property.equals("testParent")) {
            return this.testParent(node, args, expectedValue);
        }
        if (property.equals("getCacheState")) {
            File file = CacheManager.getCacheFile(node);
            if (!file.exists()) {
                return false;
            }
            CacheState state = node.getCacheState();
            return state.name().equals(expectedValue);
        }
        return false;
    }

    private boolean testParent(FSTreeNode node, Object[] args, Object expectedValue) {
        if (args == null || args.length == 0) {
            return false;
        }
        String arg = (String)args[0];
        Object[] newArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        return this.test(node.getParent(), arg, newArgs, expectedValue);
    }
}

