/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableManagerToolChain;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;

public abstract class ToolchainBuiltinSpecsDetector
extends AbstractBuiltinSpecsDetector {
    private Map<String, ITool> toolMap = new HashMap<String, ITool>();

    public abstract String getToolchainId();

    private ITool getTool(String languageId) {
        ITool tool = this.toolMap.get(languageId);
        if (tool != null) {
            return tool;
        }
        String toolchainId = null;
        IToolChain toolchain = null;
        if (this.currentCfgDescription != null) {
            IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(this.currentCfgDescription);
            toolchain = cfg != null ? cfg.getToolChain() : null;
            String string = toolchainId = toolchain != null ? toolchain.getId() : null;
        }
        if (toolchain == null) {
            toolchainId = this.getToolchainId();
            toolchain = ManagedBuildManager.getExtensionToolChain(toolchainId);
        }
        while (toolchain != null) {
            tool = this.getTool(languageId, toolchain);
            if (tool != null) break;
            toolchain = toolchain.getSuperClass();
        }
        if (this.currentCfgDescription == null && tool != null) {
            this.toolMap.put(languageId, tool);
        }
        if (tool == null) {
            ManagedBuilderCorePlugin.error("Unable to find tool in toolchain=" + toolchainId + " for language=" + languageId);
        }
        return tool;
    }

    private ITool getTool(String languageId, IToolChain toolchain) {
        ITool[] tools;
        ITool[] iToolArray = tools = toolchain.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType[] inputTypes;
            ITool tool = iToolArray[n2];
            IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
            int n3 = inputTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IInputType inType = iInputTypeArray[n4];
                String lang = inType.getLanguageId(tool);
                if (languageId.equals(lang)) {
                    return tool;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected String getCompilerCommand(String languageId) {
        ITool tool = this.getTool(languageId);
        String compilerCommand = tool.getToolCommand();
        if (compilerCommand.isEmpty()) {
            ManagedBuilderCorePlugin.error("Unable to find compiler command in toolchain=" + this.getToolchainId());
        }
        return compilerCommand;
    }

    @Override
    protected String getSpecFileExtension(String languageId) {
        String ext = null;
        ITool tool = this.getTool(languageId);
        String[] srcFileExtensions = tool.getAllInputExtensions();
        if (srcFileExtensions != null && srcFileExtensions.length > 0) {
            ext = srcFileExtensions[0];
        }
        if (ext == null || ext.isEmpty()) {
            ManagedBuilderCorePlugin.error("Unable to find file extension for language " + languageId);
        }
        return ext;
    }

    @Override
    protected List<IEnvironmentVariable> getEnvironmentVariables() {
        if (this.envMngr == null && this.currentCfgDescription == null) {
            IToolChain toolchain = ManagedBuildManager.getExtensionToolChain(this.getToolchainId());
            this.envMngr = new EnvironmentVariableManagerToolChain(toolchain);
        }
        List<IEnvironmentVariable> vars = super.getEnvironmentVariables();
        return vars;
    }
}

