/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderManager;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderToolbarHandler;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractAction
extends AbstractTerminalAction {
    private final TabFolderToolbarHandler parent;

    public AbstractAction(TabFolderToolbarHandler parent, String id) {
        super(id);
        Assert.isNotNull((Object)((Object)parent));
        this.parent = parent;
    }

    protected final TabFolderToolbarHandler getParent() {
        return this.parent;
    }

    protected ITerminalViewControl getTarget() {
        return this.getParent().getActiveTerminalViewControl();
    }

    public void run() {
        CTabItem activeTabItem;
        TabFolderManager manager = (TabFolderManager)((Object)this.getParent().getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null) {
            this.executeCommand(activeTabItem.getData("customData"));
        }
    }

    protected void executeCommand(Object data) {
        Command command;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (service != null && this.getCommandId() != null && (command = service.getCommand(this.getCommandId())) != null && command.isDefined()) {
            IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Assert.isNotNull((Object)handlerSvc);
            StructuredSelection selection = data != null ? new StructuredSelection(data) : new StructuredSelection();
            EvaluationContext context = new EvaluationContext(handlerSvc.getCurrentState(), (Object)selection);
            context.addVariable("selection", (Object)selection);
            context.addVariable("activeMenuSelection", (Object)selection);
            context.setAllowPluginActivation(true);
            try {
                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                Assert.isNotNull((Object)pCmd);
                handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)context);
            }
            catch (Exception e) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.AbstractAction_error_commandExecutionFailed, (Object)this.getCommandId(), (Object)e.getLocalizedMessage()), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    protected abstract String getCommandId();

    public void updateAction(boolean aboutToShow) {
        boolean enabled;
        boolean bl = enabled = this.getTarget() != null;
        if (enabled) {
            CTabItem activeTabItem;
            enabled = false;
            TabFolderManager manager = (TabFolderManager)((Object)this.getParent().getAdapter(TabFolderManager.class));
            if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null) {
                enabled = this.checkEnableAction(activeTabItem.getData("customData"));
            }
        }
        this.setEnabled(enabled);
    }

    protected boolean checkEnableAction(Object data) {
        return data != null;
    }

    public boolean isSeparator() {
        return false;
    }
}

