/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallWizard
extends WizardWithLicenses {
    SelectableIUsPage errorReportingPage;
    boolean ignoreSelectionChanges = false;
    IStatus installHandlerStatus;

    public InstallWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, (ProfileChangeOperation)operation, initialSelections == null ? null : initialSelections.toArray(), preloadJob);
        this.setWindowTitle(ProvUIMessages.InstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/install_wiz.gif"));
    }

    @Override
    protected ResolutionResultsWizardPage createResolutionPage() {
        return new InstallWizardPage(this.ui, this, this.root, (ProfileChangeOperation)((InstallOperation)this.operation));
    }

    @Override
    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new AvailableIUsPage(this.ui, this);
        if (selections != null && selections.length > 0) {
            this.mainPage.setCheckedElements(selections);
        }
        return this.mainPage;
    }

    @Override
    protected void initializeResolutionModelElements(Object[] selectedElements) {
        if (selectedElements == null) {
            return;
        }
        this.root = new IUElementListRoot();
        if (this.operation instanceof RemediationOperation) {
            Object[] elements = ElementUtils.requestToElement(((RemediationOperation)this.operation).getCurrentRemedy(), true);
            this.root.setChildren(elements);
            this.planSelections = elements;
        } else {
            ArrayList<AvailableIUElement> list = new ArrayList<AvailableIUElement>(selectedElements.length);
            ArrayList<AvailableIUElement> selections = new ArrayList<AvailableIUElement>(selectedElements.length);
            int i = 0;
            while (i < selectedElements.length) {
                IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
                if (iu != null) {
                    AvailableIUElement element = new AvailableIUElement(this.root, iu, this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                    list.add(element);
                    selections.add(element);
                }
                ++i;
            }
            this.root.setChildren(list.toArray());
            this.planSelections = selections.toArray();
        }
    }

    @Override
    protected Object[] getOperationSelections() {
        return this.getOperationSelectionsPage().getCheckedIUElements();
    }

    protected ISelectableIUsPage getOperationSelectionsPage() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof ISelectableIUsPage) {
            return (ISelectableIUsPage)page;
        }
        return this.mainPage;
    }

    @Override
    protected ProvisioningContext getProvisioningContext() {
        return ((AvailableIUsPage)this.mainPage).getProvisioningContext();
    }

    @Override
    protected IResolutionErrorReportingPage createErrorReportingPage() {
        this.errorReportingPage = this.root == null ? new SelectableIUsPage(this.ui, this, null, null) : new SelectableIUsPage(this.ui, this, this.root, this.root.getChildren(this.root));
        this.errorReportingPage.setTitle(ProvUIMessages.InstallWizardPage_Title);
        this.errorReportingPage.setDescription(ProvUIMessages.PreselectedIUInstallWizard_Description);
        this.errorReportingPage.updateStatus(this.root, this.operation);
        return this.errorReportingPage;
    }

    @Override
    protected RemediationPage createRemediationPage() {
        this.remediationPage = new RemediationPage(this.ui, this, this.root, this.operation);
        return this.remediationPage;
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        InstallOperation op = new InstallOperation(this.ui.getSession(), ElementUtils.elementsToIUs(elements));
        op.setProfileId(this.getProfileId());
        return op;
    }

    @Override
    protected boolean shouldUpdateErrorPageModelOnPlanChange() {
        return this.getContainer().getCurrentPage() == this.mainPage && super.shouldUpdateErrorPageModelOnPlanChange();
    }

    @Override
    protected void planChanged() {
        super.planChanged();
        this.synchSelections(this.getOperationSelectionsPage());
    }

    @Override
    public void operationSelectionsChanged(ISelectableIUsPage page) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        super.operationSelectionsChanged(page);
        if (this.getOperationSelectionsPage() == this.errorPage) {
            ((WizardPage)this.errorPage).setPageComplete(this.pageSelectionsHaveChanged(this.errorPage) && this.errorPage.getCheckedIUElements().length > 0);
        }
        this.synchSelections(page);
    }

    private void synchSelections(ISelectableIUsPage triggeringPage) {
        this.ignoreSelectionChanges = true;
        try {
            if (triggeringPage == this.errorReportingPage) {
                this.mainPage.setCheckedElements(triggeringPage.getCheckedIUElements());
            } else if (triggeringPage == this.mainPage) {
                this.errorReportingPage.setCheckedElements(triggeringPage.getCheckedIUElements());
            }
        }
        finally {
            this.ignoreSelectionChanges = false;
        }
    }

    @Override
    public IStatus getCurrentStatus() {
        IStatus originalStatus = super.getCurrentStatus();
        int sev = originalStatus.getSeverity();
        if (sev == 8 || sev == 4 || this.operation == null || this.operation.getProvisioningPlan() == null) {
            return originalStatus;
        }
        this.installHandlerStatus = UpdateManagerCompatibility.getInstallHandlerStatus(this.operation.getProvisioningPlan());
        if (!this.installHandlerStatus.isOK()) {
            this.couldNotResolveStatus = this.installHandlerStatus;
            if (ProvUI.isUpdateManagerInstallerPresent()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = ProvUI.getDefaultParentShell();
                        MessageDialog dialog = new MessageDialog(shell, ProvUIMessages.Policy_RequiresUpdateManagerTitle, null, ProvUIMessages.Policy_RequiresUpdateManagerMessage, 4, new String[]{ProvUIMessages.LaunchUpdateManagerButton, IDialogConstants.CANCEL_LABEL}, 0);
                        if (dialog.open() == 0) {
                            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                public void run() {
                                    UpdateManagerCompatibility.openInstaller();
                                }
                            });
                        }
                    }
                });
            }
            return this.installHandlerStatus;
        }
        return originalStatus;
    }

    @Override
    public boolean statusOverridesOperation() {
        return this.installHandlerStatus != null && !this.installHandlerStatus.isOK() && this.couldNotResolveStatus == this.installHandlerStatus;
    }
}

