/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.file;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.tcf.te.ui.controls.BaseDialogSelectionControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.DirectoryNameValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class DirectorySelectionControl
extends BaseDialogSelectionControl {
    private String dialogMessage = "";

    public DirectorySelectionControl(IDialogPage parentPage) {
        super(parentPage);
        this.setDialogTitle(Messages.DirectorySelectionControl_title);
        this.setGroupLabel(Messages.DirectorySelectionControl_group_label);
        this.setEditFieldLabel(Messages.DirectorySelectionControl_editfield_label);
    }

    public void setDialogMessage(String message) {
        this.dialogMessage = message == null ? "" : message;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }

    @Override
    protected Dialog doCreateDialogControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
        return dialog;
    }

    @Override
    protected void configureDialogControl(Dialog dialog) {
        super.configureDialogControl(dialog);
        if (dialog instanceof DirectoryDialog) {
            DirectoryDialog directoryDialog = (DirectoryDialog)dialog;
            String selectedDirectory = this.doGetSelectedDirectory();
            if (selectedDirectory != null && selectedDirectory.trim().length() > 0) {
                directoryDialog.setFilterPath(selectedDirectory);
            } else if (Platform.getBundle((String)"org.eclipse.core.resources") != null && Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
                directoryDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
            directoryDialog.setMessage(this.getDialogMessage());
        }
    }

    protected String doGetSelectedDirectory() {
        return this.getEditFieldControlText();
    }

    @Override
    protected Validator doCreateEditFieldValidator() {
        return new DirectoryNameValidator(15);
    }

    @Override
    public void setEditFieldValidator(Validator editFieldValidator) {
        Assert.isTrue((boolean)(editFieldValidator instanceof DirectoryNameValidator));
        if (editFieldValidator instanceof DirectoryNameValidator) {
            super.setEditFieldValidator(editFieldValidator);
        }
    }

    @Override
    protected String doOpenDialogControl(Dialog dialog) {
        Assert.isNotNull((Object)dialog);
        if (dialog instanceof DirectoryDialog) {
            DirectoryDialog directoryDialog = (DirectoryDialog)dialog;
            return directoryDialog.open();
        }
        return null;
    }
}

