/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class GetInputStreamCommand
extends AbstractCommand<InputStream> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final int options;
    private final String path;

    public GetInputStreamCommand(ProxyConnection conn, int options, String path) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.options = options;
        this.path = path;
    }

    @Override
    public InputStream call() throws ProxyException {
        try {
            StreamChannel chan = this.openChannel();
            this.out.writeByte(1);
            this.out.writeShort(108);
            this.out.writeByte(chan.getId());
            this.out.writeInt(this.options);
            this.out.writeUTF(this.path);
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                throw new ProxyException(errMsg);
            }
            return new BufferedInputStream(chan.getInputStream());
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

