/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.actions.AddPHPExceptionBreakpointDialog;
import org.eclipse.php.internal.debug.ui.actions.Messages;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddPHPExceptionBreakpointHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SelectionDialog dialog = this.createDialog();
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        Object[] types = dialog.getResult();
        this.addBreakpoints(types);
        return null;
    }

    protected SelectionDialog createDialog() {
        AddPHPExceptionBreakpointDialog dialog = new AddPHPExceptionBreakpointDialog();
        dialog.setTitle(Messages.AddPHPExceptionBreakpointHandler_Dialog_title);
        return dialog;
    }

    protected void addBreakpoints(Object[] exceptions) {
        Object[] objectArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Object exception = objectArray[n2];
            IType type = (IType)exception;
            String exceptionName = type.getElementName();
            if (!this.hasBreakpoint(exceptionName)) {
                PHPExceptionBreakpoint exceptionBreakpoint = type instanceof AddPHPExceptionBreakpointDialog.ErrorType ? new PHPExceptionBreakpoint(exceptionName, IPHPExceptionBreakpoint.Type.ERROR) : new PHPExceptionBreakpoint(exceptionName, IPHPExceptionBreakpoint.Type.EXCEPTION);
                try {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)exceptionBreakpoint);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
            ++n2;
        }
    }

    protected boolean hasBreakpoint(String exceptionName) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPExceptionBreakpoint exceptionBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IPHPExceptionBreakpoint && (exceptionBreakpoint = (IPHPExceptionBreakpoint)breakpoint).getExceptionName().equals(exceptionName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

