/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class BucketMap<K, V> {
    private Map<K, Set<V>> map;
    private Set<V> defaultSet = new HashSet<V>(1);

    public BucketMap() {
        this.map = new HashMap<K, Set<V>>();
    }

    public BucketMap(Set<V> set) {
        this();
        this.defaultSet = set;
    }

    public BucketMap(int size) {
        this.map = new HashMap<K, Set<V>>(size);
    }

    public void add(K key, V value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            values = this.createSet();
            this.map.put(key, values);
        }
        values.add(value);
    }

    private Set<V> createSet() {
        if (this.defaultSet instanceof Cloneable) {
            try {
                Method method = this.defaultSet.getClass().getMethod("clone", new Class[]{null});
                return (Set)method.invoke(this.defaultSet, new Object[0]);
            }
            catch (Exception exception) {}
        }
        try {
            return (Set)this.defaultSet.getClass().newInstance();
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
            return new HashSet(1);
        }
    }

    public void addAll(K key, Collection<V> newValues) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            values = this.createSet();
            this.map.put(key, values);
        }
        values.addAll(newValues);
    }

    public void merge(BucketMap<K, V> bucketMap) {
        for (K key : bucketMap.getKeys()) {
            this.addAll(key, bucketMap.getSet(key));
        }
    }

    public boolean contains(K key, V value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<V> get(K key) {
        Set<V> values = this.getSet(key);
        if (values == null) {
            return this.createSet();
        }
        return values;
    }

    public Set<V> getSet(Object key) {
        return this.map.get(key);
    }

    public Set<V> getAll() {
        Set<V> valuesSet = this.createSet();
        for (Set<V> values : this.map.values()) {
            for (V v : values) {
                valuesSet.add(v);
            }
        }
        return valuesSet;
    }

    public boolean remove(K key, V value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            return false;
        }
        boolean result = values.remove(value);
        if (values.size() == 0) {
            this.map.remove(key);
        }
        return result;
    }

    public Collection<V> removeAll(K key) {
        if (this.map.remove(key) != null) {
            return this.map.remove(key);
        }
        return this.createSet();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> getKeys() {
        return this.map.keySet();
    }
}

