/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP7;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP71;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP71
extends ASTRewriteTestsPHP7 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP7_1;
    }

    @Test
    public void useStatementFunctionSet2() throws Exception {
        String str = "<?php use Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use Foo\\{function Bar}; \n ?>");
    }

    @Test
    public void useStatementFunctionSet2b() throws Exception {
        String str = "<?php use \\Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use \\Foo\\{function Bar}; \n ?>");
    }

    @Test
    public void useStatementConstSet2() throws Exception {
        String str = "<?php use Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use Foo\\{const Bar}; \n ?>");
    }

    @Test
    public void useStatementConstSet2b() throws Exception {
        String str = "<?php use \\Foo\\{Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 1 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use \\Foo\\{const Bar}; \n ?>");
    }

    @Test
    public void useStatementFunctionSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, function Bar2}; \n ?>");
    }

    @Test
    public void useStatementFunctionSet3b() throws Exception {
        String str = "<?php use function \\Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, function Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet3b() throws Exception {
        String str = "<?php use function \\Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet4() throws Exception {
        String str = "<?php use Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementConstSet4b() throws Exception {
        String str = "<?php use \\Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use const Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet2() throws Exception {
        String str = "<?php use Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet2b() throws Exception {
        String str = "<?php use \\Foo\\{const Bar, function Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use \\Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet3() throws Exception {
        String str = "<?php use function Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet3b() throws Exception {
        String str = "<?php use function \\Foo\\{Bar, Bar2}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 2 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar2}; \n ?>");
    }

    @Test
    public void useStatementNoneSet4() throws Exception {
        String str = "<?php use Foo\\{function Bar, Bar, const Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 3 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(2)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\{Bar, Bar, Bar}; \n ?>");
    }

    @Test
    public void useStatementNoneSet4b() throws Exception {
        String str = "<?php use \\Foo\\{function Bar, Bar, const Bar}; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        Assert.assertTrue((String)"Unexpected parts list size.", (statements.get(0).parts().size() == 3 ? 1 : 0) != 0);
        ((UseStatementPart)statements.get(0).parts().get(0)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(1)).setStatementType(0);
        ((UseStatementPart)statements.get(0).parts().get(2)).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use \\Foo\\{Bar, Bar, Bar}; \n ?>");
    }

    @Test
    public void useMultipleExceptions() throws Exception {
        String str = "<?php try { } catch (Exception1 | Exception2 | Exception3 $e) { } \n ?>";
        this.initialize(str);
        List<CatchClause> catchClauses = this.getAllOfType(this.program, CatchClause.class);
        Assert.assertTrue((String)"Unexpected list size.", (catchClauses.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected exceptions list size.", (catchClauses.get(0).getClassNames().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected content.", (boolean)(catchClauses.get(0).getClassNames().get(2) instanceof NamespaceName));
        ((Identifier)((NamespaceName)catchClauses.get(0).getClassNames().get(2)).segments().get(0)).setName("Exception4");
        this.rewrite();
        this.checkResult("<?php try {} catch (Exception1 | Exception2 | Exception4 $e) {} \n ?>");
    }

    @Test
    public void useCoalesceOperator() throws Exception {
        String str = "<?php $a = $test ?? 0; \n ?>";
        this.initialize(str);
        List<ConditionalExpression> conditionalExpressions = this.getAllOfType(this.program, ConditionalExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (conditionalExpressions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected content 1.", (boolean)(conditionalExpressions.get(0).getIfTrue() instanceof Scalar));
        Assert.assertTrue((String)"Unexpected content 2.", (conditionalExpressions.get(0).getIfFalse() == conditionalExpressions.get(0).getCondition() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected content 3.", (conditionalExpressions.get(0).getOperatorType() == 1 ? 1 : 0) != 0);
        ((Scalar)conditionalExpressions.get(0).getIfTrue()).setStringValue("1");
        this.rewrite();
        this.checkResult("<?php $a = $test ?? 1; \n ?>");
    }

    @Test
    public void useBracketedNamespaceDeclaration() throws Exception {
        String str = "<?php namespace A {$a = 5;} \n ?>";
        this.initialize(str);
        List<NamespaceDeclaration> namespaceDeclarations = this.getAllOfType(this.program, NamespaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (namespaceDeclarations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected content 1.", (boolean)namespaceDeclarations.get(0).isBracketed());
        Assert.assertTrue((String)"Unexpected content 2.", (namespaceDeclarations.get(0).getBody() != null ? 1 : 0) != 0);
        namespaceDeclarations.get(0).getBody().statements().clear();
        this.rewrite();
        this.checkResult("<?php namespace A {} \n ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP71.class, NodeDeletionTestsPHP71.class})
    public static class Suite {
    }
}

