/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProgressBar
extends Canvas {
    private static final int DEFAULT_HEIGHT = 18;
    private static final int DEFAULT_WIDTH = 160;
    private int fColorBarWidth = 0;
    private int fCurrentTickCount = 0;
    private boolean fError;
    private Color fFailureColor;
    private int fMaxTickCount = 0;
    private Color fOKColor;
    private boolean fStopped = false;
    private Color fStoppedColor;

    public ProgressBar(Composite parent) {
        super(parent, 0);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProgressBar.this.fColorBarWidth = ProgressBar.this.scale(ProgressBar.this.fCurrentTickCount);
                ProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ProgressBar.this.paint(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProgressBar.this.fFailureColor.dispose();
                ProgressBar.this.fOKColor.dispose();
                ProgressBar.this.fStoppedColor.dispose();
            }
        });
        Display display = parent.getDisplay();
        this.fFailureColor = new Color((Device)display, 159, 63, 63);
        this.fOKColor = new Color((Device)display, 95, 191, 95);
        this.fStoppedColor = new Color((Device)display, 120, 120, 120);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(160, 18);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        this.setStatusColor(gc);
        this.fColorBarWidth = Math.min(rect.width - 2, this.fColorBarWidth);
        gc.fillRectangle(1, 1, this.fColorBarWidth, rect.height - 2);
    }

    private void paintStep(int startX, int endX) {
        GC gc = new GC((Drawable)this);
        this.setStatusColor(gc);
        Rectangle rect = this.getClientArea();
        startX = Math.max(1, startX);
        gc.fillRectangle(startX, 1, endX - startX, rect.height - 2);
        gc.dispose();
    }

    public void reset() {
        this.fError = false;
        this.fStopped = false;
        this.fCurrentTickCount = 0;
        this.fColorBarWidth = 0;
        this.fMaxTickCount = 0;
        this.redraw();
    }

    private int scale(int value) {
        if (this.fMaxTickCount > 0) {
            Rectangle r = this.getClientArea();
            if (r.width != 0) {
                return Math.max(0, value * (r.width - 2) / this.fMaxTickCount);
            }
        }
        return value;
    }

    public void setMaximum(int max) {
        this.fMaxTickCount = max;
    }

    private void setStatusColor(GC gc) {
        if (this.fStopped) {
            gc.setBackground(this.fStoppedColor);
        } else if (this.fError) {
            gc.setBackground(this.fFailureColor);
        } else if (this.fStopped) {
            gc.setBackground(this.fStoppedColor);
        } else {
            gc.setBackground(this.fOKColor);
        }
    }

    public void step(boolean failed, int tickCount) {
        this.fCurrentTickCount = tickCount;
        int x = this.fColorBarWidth;
        this.fColorBarWidth = this.scale(this.fCurrentTickCount);
        if (!this.fError && failed) {
            this.fError = true;
            x = 1;
        }
        if (this.fCurrentTickCount == this.fMaxTickCount) {
            this.fColorBarWidth = this.getClientArea().width - 1;
        }
        this.paintStep(x, this.fColorBarWidth);
    }

    public void stopped() {
        this.fStopped = true;
        this.redraw();
    }
}

