/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class NamespaceResolverTest {
    private IProject project;
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();

    @Test
    public void testNamespaceResolver() throws CoreException, IOException {
        this.project = TestUtils.createProject((String)"namespace-resolver");
        Assert.assertNotNull((Object)this.project);
        ComposerCoreTestPlugin.copyProjectFiles(this.project);
        this.project.refreshLocal(2, null);
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        PHPFacets.setFacetedVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, null);
        TestUtils.waitForIndexer();
        TestUtils.waitForAutoBuild();
        IComposerProject project = ComposerPlugin.getDefault().getComposerProject(this.project);
        IFile composerJson = project.getComposerJson();
        Assert.assertNotNull((Object)composerJson);
        Assert.assertTrue((boolean)project.getProject().hasNature("org.eclipse.php.core.PHPNature"));
        Assert.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)this.project));
        Assert.assertEquals((Object)"Foo\\Bar", (Object)project.getNamespace((IPath)new Path("src/Foo/Bar")));
        Assert.assertEquals((Object)"Foo\\Bar\\Baz", (Object)project.getNamespace((IPath)new Path("src/Foo/Bar/Baz")));
        Assert.assertEquals((Object)"Hello\\World", (Object)project.getNamespace((IPath)new Path("src/HelloWorld")));
        Assert.assertEquals((Object)"", (Object)project.getNamespace((IPath)new Path("src/Null/")));
        Assert.assertEquals((Object)"Wurst", (Object)project.getNamespace((IPath)new Path("src/Null/Wurst")));
        Assert.assertEquals((Object)"Blut\\Wurst", (Object)project.getNamespace((IPath)new Path("src/Null/Blut/Wurst")));
    }

    @After
    public void cleanup() throws CoreException {
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }
}

