/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.util.INamespaceResolver;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CoreNamespaceResolverTests {
    private static IProject project;

    @BeforeClass
    public static void setup() throws CoreException {
        TestUtils.disableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
        project = TestUtils.createProject((String)"composer_namespace_resolver");
        TestUtils.createFolder((IProject)project, (String)"src");
        TestUtils.createFolder((IProject)project, (String)"tests");
        DLTKCore.create((IProject)project).setRawBuildpath(new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)project.getFullPath().append("src")), DLTKCore.newSourceEntry((IPath)project.getFullPath().append("tests"))}, (IProgressMonitor)new NullProgressMonitor());
        IFile file = project.getFile("composer.json");
        file.create((InputStream)new ByteArrayInputStream("{\"autoload\": {\"psr-4\" : {\"App\\\\\" : \"src/\"} }, \"autoload-dev\": {\"psr-4\" : {\"App\\\\Tests\\\\\" : \"tests/\"} }   }".getBytes()), true, null);
        TestUtils.setProjectPHPVersion((IProject)project, (PHPVersion)PHPVersion.PHP5_3);
        PHPFacets.setFacetedVersion((IProject)project, (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)project, (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
    }

    @AfterClass
    public static void cleanup() {
        TestUtils.deleteProject((IProject)project);
        project = null;
        TestUtils.enableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
    }

    @Test
    public void testSimpleResolveNamespace() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)project);
        Assert.assertEquals((Object)"App", (Object)resolver.resolveNamespace(project.getFullPath().append("src")));
        Assert.assertEquals((Object)"App\\Api", (Object)resolver.resolveNamespace(project.getFullPath().append("src").append("Api")));
        Assert.assertEquals((Object)"App\\Tests\\Api", (Object)resolver.resolveNamespace(project.getFullPath().append("tests").append("Api")));
    }

    @Test
    public void testSimpleResolveLocation() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)project);
        Assert.assertEquals((Object)project.getFullPath().append("src"), (Object)resolver.resolveLocation(project.getFullPath(), "App"));
        Assert.assertEquals((Object)project.getFullPath().append("src").append("Api"), (Object)resolver.resolveLocation(project.getFullPath(), "App\\Api"));
        Assert.assertEquals((Object)project.getFullPath().append("tests").append("Something"), (Object)resolver.resolveLocation(project.getFullPath(), "App\\Tests\\Something"));
    }
}

