/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.test.ComposertTestCase;
import org.junit.Test;

public class JsonWriterTest
extends ComposertTestCase {
    private ComposerPackage phpPackage;
    private String json;

    public void setUp() {
        this.phpPackage = this.createDummyPackage();
        this.json = this.phpPackage.toJson();
    }

    @Test
    public void testToJson() {
        JsonWriterTest.assertNotNull((Object)this.json);
    }

    @Test
    public void testEmptyPackage() {
        ComposerPackage pkg = new ComposerPackage();
        JsonWriterTest.assertEquals((String)"{}", (String)pkg.toJson());
    }

    @Test
    public void testKeywords() {
        ComposerPackage pkg = new ComposerPackage();
        pkg.getKeywords().add((Object)"bla");
        JsonWriterTest.assertNotSame((Object)"{\n\t\"keywords\" : \"bla\"\n}", (Object)pkg.toJson());
        pkg.getKeywords().add((Object)"blubb");
        JsonWriterTest.assertEquals((String)"{\n\t\"keywords\" : [\n\t\t\"bla\",\n\t\t\"blubb\"\n\t]\n}", (String)pkg.toJson());
    }

    @Test
    public void testLicense() {
        ComposerPackage pkg = new ComposerPackage();
        pkg.getLicense().add("MIT");
        JsonWriterTest.assertEquals((String)"{\n\t\"license\" : \"MIT\"\n}", (String)pkg.toJson());
        pkg.getLicense().add("EPL");
        JsonWriterTest.assertEquals((String)"{\n\t\"license\" : [\n\t\t\"MIT\",\n\t\t\"EPL\"\n\t]\n}", (String)pkg.toJson());
    }

    @Test
    public void testComposerPackage() {
        try {
            this.doTestComposerPackage(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testDependencies() {
        try {
            this.doTestDependencies(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testAutoload() {
        try {
            this.doTestAutoload(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testConfig() {
        try {
            this.doTestConfig(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testScripts() {
        try {
            this.doTestScripts(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testSupport() {
        try {
            this.doTestSupport(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testRepositories() {
        try {
            this.doTestRepositories(new ComposerPackage(this.json));
        }
        catch (ParseException e) {
            e.printStackTrace();
            JsonWriterTest.fail();
        }
    }

    @Test
    public void testSimplePackage() {
        ComposerPackage pkg = new ComposerPackage();
        pkg.setName("test/package");
        pkg.setType("");
    }
}

