/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ArrayElement;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTests;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP54
extends ASTRewriteTests {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5_4;
    }

    @Override
    @Test
    public void classConstant() throws Exception {
        String str = "<?php $a = MyClass::MY_CONST; ?>";
        this.initialize(str);
        List<StaticConstantAccess> staticConstants = this.getAllOfType(this.program, StaticConstantAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticConstants.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)staticConstants.get(0).getClassName()).segments().get(0)).setName("Foo");
        staticConstants.get(0).setConstant(this.ast.newIdentifier("BAR_CONST"));
        this.rewrite();
        this.checkResult("<?php $a = Foo::BAR_CONST; ?>");
    }

    @Override
    @Test
    public void classDeclarationReplaceSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).getSuperClass()).segments().get(0)).setName("Bar");
        this.rewrite();
        this.checkResult("<?php class MyClass extends Bar { } ?> ");
    }

    @Override
    @Test
    public void classDeclarationRenameInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).interfaces().get(1)).segments().get(0)).setName("BooBo");
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Foo,BooBo{ } ?> ");
    }

    @Override
    @Test
    public void interfaceDeclarationRenameExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)declarations.get(0).interfaces().get(0)).segments().get(0)).setName("Boobo");
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Boobo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Override
    @Test
    public void emptyHeredoc() throws Exception {
        String str = "<?php <<<Heredoc\nHeredoc;\n?>";
        this.initialize(str);
        this.checkResult("<?php <<<Heredoc\nHeredoc;\n?>");
    }

    @Test
    public void traitDeclarationSimple() throws Exception {
        String str = "<?php trait MyTrait { } ?> ";
        this.initialize(str);
        List<TraitDeclaration> declarations = this.getAllOfType(this.program, TraitDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php trait Foo { } ?> ");
    }

    @Test
    public void traitFieldDeclaration() throws Exception {
        String str = "<?php trait A { public $a = 3; final private static $var; }?>";
        this.initialize(str);
        List<FieldsDeclaration> declarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 2 ? 1 : 0) != 0);
        declarations.get(0).fields().add(this.ast.newSingleFieldDeclaration(this.ast.newVariable("b"), (Expression)this.ast.newScalar("4")));
        ((SingleFieldDeclaration)declarations.get(0).fields().get(0)).getValue().delete();
        declarations.get(1).setModifier(36);
        this.rewrite();
        this.checkResult("<?php trait A { public $a, $b = 4; protected final $var; }?>");
    }

    @Test
    public void traitFunctionDeclaration() throws Exception {
        String str = "<?php function foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setFunctionName(this.ast.newIdentifier("bar"));
        declarations.get(0).formalParameters().add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), null, false));
        this.rewrite();
        this.checkResult("<?php function bar(int $a) {} ?> ");
    }

    @Test
    public void functionDeclarationWithCallableParam2() throws Exception {
        String str = "<?php function foo($a, callable $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    @Test
    public void traitMethodDeclaration() throws Exception {
        String str = "<?php trait A { public function foo(int $a){} }?> ";
        this.initialize(str);
        List<MethodDeclaration> declarations = this.getAllOfType(this.program, MethodDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(33);
        declarations.get(0).getFunction().setFunctionName(this.ast.newIdentifier("bar"));
        this.rewrite();
        this.checkResult("<?php trait A { protected abstract function bar(int $a){} }?> ");
    }

    @Test
    public void arrayInitializer() throws Exception {
        String str = "<?php $f = [new Human('Gonzalo'), 'hello']; ?>";
        this.initialize(str);
        List<ArrayElement> arrayAccess = this.getAllOfType(this.program, ArrayElement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 2 ? 1 : 0) != 0);
        ((Scalar)arrayAccess.get(1).getValue()).setStringValue("'world'");
        this.rewrite();
        this.checkResult("<?php $f = [new Human('Gonzalo'), 'world']; ?>");
    }

    @Test
    public void classInitializer() throws Exception {
        String str = "<?php (new Human('Gonzalo'))->hello(); ?>";
        this.initialize(str);
        List<FunctionInvocation> arrayAccess = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        Variable name = this.ast.newVariable("world");
        name.setIsDollared(false);
        arrayAccess.get(0).getFunctionName().setName((Expression)name);
        this.rewrite();
        this.checkResult("<?php (new Human('Gonzalo'))->world(); ?>");
    }

    @Test
    public void expresionFunctionInvocation() throws Exception {
        String str = "<?php $human->{'hello'}(); ?>";
        this.initialize(str);
        List<FunctionInvocation> arrayAccess = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        ((Variable)arrayAccess.get(0).getFunctionName().getName()).setName((Expression)this.ast.newScalar("'world'"));
        this.rewrite();
        this.checkResult("<?php $human->{'world'}(); ?>");
    }

    @Test
    public void staticLambdaFunction() throws Exception {
        String str = "<?php $lambda = static function () { }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> arrayAccess = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void useTrait1() throws Exception {
        String str = "<?php class Test { use Hello, World; } ?>";
        this.initialize(str);
        List<TraitUseStatement> arrayAccess = this.getAllOfType(this.program, TraitUseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        ((Identifier)((NamespaceName)arrayAccess.get(0).getTraitList().get(0)).segments().get(0)).setName("Hi");
        this.rewrite();
        this.checkResult("<?php class Test { use Hi, World; } ?>");
    }

    @Test
    public void useTrait2() throws Exception {
        String str = "<?php class Aliased_Talker { use A, B {B::smallTalk insteadof A;\nA::bigTalk insteadof B;\nB::bigTalk as talk;\n}\n } ?>";
        this.initialize(str);
        List<TraitPrecedenceStatement> arrayAccess = this.getAllOfType(this.program, TraitPrecedenceStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 2 ? 1 : 0) != 0);
        ((Identifier)arrayAccess.get(0).getPrecedence().getMethodReference().getClassName().segments().get(0)).setName("B1");
        arrayAccess.get(0).getPrecedence().getMethodReference().setFunctionName(this.ast.newIdentifier("bigTalk"));
        List<TraitAliasStatement> aliasStatement = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (aliasStatement.size() == 1 ? 1 : 0) != 0);
        aliasStatement.get(0).getAlias().setFunctionName(this.ast.newIdentifier("talking"));
        this.rewrite();
        this.checkResult("<?php class Aliased_Talker { use A, B {B1::bigTalk insteadof A;\nA::bigTalk insteadof B;\nB::bigTalk as talking;\n}\n } ?>");
    }

    @Test
    public void useTrait3() throws Exception {
        String str = "<?php class Test { use HelloWorld { sayHello as protected; } } ?>";
        this.initialize(str);
        List<TraitAliasStatement> arrayAccess = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).getAlias().setModifier(64);
        this.rewrite();
        this.checkResult("<?php class Test { use HelloWorld { sayHello as public; } } ?>");
    }

    @Test
    public void useTrait4() throws Exception {
        String str = "<?php class Test { use HelloWorld { sayHello as private myPrivateHello; } } ?>";
        this.initialize(str);
        List<TraitAliasStatement> arrayAccess = this.getAllOfType(this.program, TraitAliasStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).getAlias().setModifier(64);
        arrayAccess.get(0).getAlias().setFunctionName(this.ast.newIdentifier("myPublicHello"));
        this.rewrite();
        this.checkResult("<?php class Test { use HelloWorld { sayHello as public myPublicHello; } } ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP54.class, NodeDeletionTests.class, ASTRewriteTestsPHP54.class})
    public static class Suite {
    }
}

