/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.php.astview.ASTViewPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    private EditorUtility() {
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = ASTViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static ISourceModule getPhpInput(IEditorPart part) {
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput != null) {
            ISourceModule input = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editorInput);
            return input;
        }
        return null;
    }

    public static void selectInEditor(ITextEditor editor, int offset, int length) {
        IEditorPart active = EditorUtility.getActiveEditor();
        if (active != editor) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
        }
        editor.selectAndReveal(offset, length);
    }
}

