/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.editor;

import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class BracketInserterTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    private IProject project;
    private IFile testFile;
    private PHPVersion phpVersion;
    private PHPStructuredEditor fEditor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    public static final String DEFAULT_CURSOR = "|";

    static {
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/bracket-inserter"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/bracket-inserter"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/bracket-inserter"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/bracket-inserter"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public BracketInserterTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("Bracket_Inserter_" + String.valueOf(this.phpVersion)));
        ResourcesPlugin.getWorkspace().getRoot().getProject("Bracket_Inserter_" + String.valueOf(this.phpVersion));
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
    }

    @Test
    public void typing(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        this.doTyping(pdttFile);
    }

    private void doTyping(final PdttFile pdttFile) throws Exception {
        String pdttFileData = pdttFile.getFile();
        String cursor = this.getCursor(pdttFile) != null ? this.getCursor(pdttFile) : DEFAULT_CURSOR;
        final int offset = pdttFileData.lastIndexOf(cursor);
        final String data = pdttFileData.substring(0, offset) + pdttFileData.substring(offset + 1);
        final Exception[] exception = new Exception[1];
        final String[] result = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    pdttFile.applyPreferences();
                    Object fileName = Paths.get(pdttFile.getFileName(), new String[0]).getFileName().toString();
                    fileName = ((String)fileName).substring(0, ((String)fileName).indexOf(46)) + ".php";
                    char c = pdttFile.getOther() != null && !pdttFile.getOther().isEmpty() ? (char)pdttFile.getOther().charAt(0) : (char)'\n';
                    BracketInserterTests.this.createFiles(data, (String)fileName);
                    BracketInserterTests.this.openEditor();
                    result[0] = BracketInserterTests.this.executeTyping(offset, c);
                    BracketInserterTests.this.closeEditor();
                    BracketInserterTests.this.deleteFiles();
                }
                catch (Exception e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)result[0]);
    }

    private void deleteFiles() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    private String getCursor(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("cursor");
    }

    private void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.test.editor", false);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    private void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
    }

    private String executeTyping(int offset, char character) {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = this.fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            Assert.fail((String)("fEditor.getTextViewer() returns null for file " + String.valueOf(this.testFile.getFullPath()) + "(" + String.valueOf(this.testFile.getLocation()) + ")"));
        }
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(offset);
        String oldContent = this.fEditor.getDocument().get();
        Event e = new Event();
        e.character = character;
        e.display = Display.getDefault();
        e.type = 1;
        e.widget = textWidget;
        VerifyEvent ve = new VerifyEvent(e);
        this.fEditor.getfBracketInserter().verifyKey(ve);
        String newContent = this.fEditor.getDocument().get();
        if (oldContent.equals(newContent)) {
            textWidget.insert(String.valueOf(character));
            return this.fEditor.getDocument().get();
        }
        return newContent;
    }

    private void createFiles(String content, String fileName) throws Exception {
        this.testFile = TestUtils.createFile((IProject)this.project, (String)new Path(fileName).lastSegment(), (String)content);
        TestUtils.waitForIndexer();
    }
}

