/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.report.HTMLReporter;
import org.eclipse.php.profile.ui.utils.ProfileUITools;
import org.eclipse.php.profile.ui.views.AbstractProfilerView;
import org.eclipse.php.profile.ui.wizards.AbstractSessionWizard;
import org.eclipse.php.profile.ui.wizards.HTMLReportWizardFirstPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.WorkbenchJob;

public class HTMLReportWizard
extends AbstractSessionWizard
implements IExportWizard {
    private HTMLReportWizardFirstPage page1;

    private void openView(String viewID, ProfilerDB input) {
        IViewPart view = ProfileUITools.findExistingView(viewID);
        if (view instanceof AbstractProfilerView) {
            ((AbstractProfilerView)view).setInput(input);
        }
    }

    public boolean performFinish() {
        WorkbenchJob reportJob = new WorkbenchJob(PHPProfileUIMessages.getString("HTMLReportWizard.0")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    String targetFile = HTMLReportWizard.this.page1.getTargetFile();
                    ProfilerDB session = HTMLReportWizard.this.page1.getSession();
                    ArrayList<String> viewIds = new ArrayList<String>();
                    if (HTMLReportWizard.this.page1.isExportCommonInfo()) {
                        HTMLReportWizard.this.openView("org.eclipse.php.profile.ui.views.ProfilerInformationView", session);
                        viewIds.add("org.eclipse.php.profile.ui.views.ProfilerInformationView");
                    }
                    if (HTMLReportWizard.this.page1.isExportExecutionStatistics()) {
                        HTMLReportWizard.this.openView("org.eclipse.php.profile.ui.views.ExecutionStatisticsView", session);
                        viewIds.add("org.eclipse.php.profile.ui.views.ExecutionStatisticsView");
                    }
                    if (HTMLReportWizard.this.page1.isExportExecutionFlow()) {
                        HTMLReportWizard.this.openView("org.eclipse.php.profile.ui.views.ExecutionFlowView", session);
                        viewIds.add("org.eclipse.php.profile.ui.views.ExecutionFlowView");
                    }
                    PrintWriter out = new PrintWriter(new FileWriter(targetFile));
                    HTMLReporter.generateReport(session, viewIds.toArray(new String[viewIds.size()]), out);
                    HTMLReporter.saveImages(new File(targetFile).getParent());
                    out.close();
                }
                catch (IOException e) {
                    ProfilerUiPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        reportJob.setUser(true);
        reportJob.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(PHPProfileUIMessages.getString("HTMLReportWizard.1"));
        this.initSessionFromSelection(workbench);
    }

    public void addPages() {
        this.page1 = new HTMLReportWizardFirstPage(this.getSession());
        this.addPage((IWizardPage)this.page1);
    }

    public Image getDefaultPageImage() {
        return ProfilerUIImages.get("IMG_WIZBAN_EXPORT_HTML_REPORT");
    }
}

