/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IScalable;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.mvc.examples.logo.model.AbstractGeometricElement;
import org.eclipse.gef.mvc.examples.logo.model.GeometricShape;
import org.eclipse.gef.mvc.examples.logo.parts.AbstractGeometricElementPart;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class GeometricShapePart
extends AbstractGeometricElementPart<GeometryNode<IShape>>
implements ITransformableContentPart<GeometryNode<IShape>>,
IResizableContentPart<GeometryNode<IShape>> {
    private final ChangeListener<? super Paint> fillObserver = new ChangeListener<Paint>(){

        public void changed(ObservableValue<? extends Paint> observable, Paint oldValue, Paint newValue) {
            GeometricShapePart.this.refreshVisual();
        }
    };
    private final boolean debugging = false;
    private Rectangle layoutBoundsRect;

    @Override
    protected void doActivate() {
        super.doActivate();
        this.getContent().fillProperty().addListener(this.fillObserver);
    }

    protected void doAddContentChild(Object contentChild, int index) {
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        if (!(contentAnchorage instanceof AbstractGeometricElement)) {
            throw new IllegalArgumentException("Cannot attach to content anchorage: wrong type!");
        }
        this.getContent().getAnchorages().add((AbstractGeometricElement)contentAnchorage);
    }

    protected GeometryNode<IShape> doCreateVisual() {
        GeometryNode geometryNode = new GeometryNode();
        return geometryNode;
    }

    @Override
    protected void doDeactivate() {
        this.getContent().fillProperty().removeListener(this.fillObserver);
        super.doDeactivate();
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        this.getContent().getAnchorages().remove(contentAnchorage);
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        for (AbstractGeometricElement<? extends IGeometry> anchorage : this.getContent().getAnchorages()) {
            anchorages.put(anchorage, (Object)"link");
        }
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void doRefreshVisual(GeometryNode<IShape> visual) {
        AffineTransform transform;
        GeometricShape content = this.getContent();
        if (visual.getGeometry() != content.getGeometry()) {
            visual.setGeometry((IGeometry)((IShape)content.getGeometry()));
        }
        if ((transform = content.getTransform()) != null) {
            this.setVisualTransform(Geometry2FX.toFXAffine((AffineTransform)transform));
        }
        if (visual.getStroke() != content.getStroke()) {
            visual.setStroke(content.getStroke());
        }
        if (visual.getStrokeWidth() != content.getStrokeWidth()) {
            visual.setStrokeWidth(content.getStrokeWidth());
        }
        if (visual.getFill() != content.getFill()) {
            visual.setFill(content.getFill());
        }
        super.doRefreshVisual(visual);
    }

    protected void doRemoveContentChild(Object contentChild) {
    }

    protected void doReorderContentChild(Object contentChild, int newIndex) {
    }

    @Override
    public GeometricShape getContent() {
        return (GeometricShape)super.getContent();
    }

    public Dimension getContentSize() {
        return ((IShape)this.getContent().getGeometry()).getBounds().getSize();
    }

    public Affine getContentTransform() {
        return Geometry2FX.toFXAffine((AffineTransform)this.getContent().getTransform());
    }

    public void setContent(Object model) {
        if (model != null && !(model instanceof GeometricShape)) {
            throw new IllegalArgumentException("Only IShape models are supported.");
        }
        super.setContent(model);
    }

    public void setContentSize(Dimension size) {
        IShape geometry = (IShape)this.getContent().getGeometry();
        org.eclipse.gef.geometry.planar.Rectangle geometricBounds = geometry.getBounds();
        double sx = (size.width - this.getContent().getStrokeWidth()) / geometricBounds.getWidth();
        double sy = (size.height - this.getContent().getStrokeWidth()) / geometricBounds.getHeight();
        ((IScalable)geometry).scale(sx, sy, geometricBounds.getX(), geometricBounds.getY());
    }

    public void setContentTransform(Affine totalTransform) {
        this.getContent().setTransform(FX2Geometry.toAffineTransform((Transform)totalTransform));
    }

    private void updateLayoutBoundsRect(GeometryNode<IShape> geometryNode) {
        Bounds boundsInScene = geometryNode.localToScene(geometryNode.getLayoutBounds());
        Bounds boundsInParent = ((InfiniteCanvasViewer)this.getRoot().getViewer()).getCanvas().getScrolledOverlayGroup().sceneToLocal(boundsInScene);
        this.layoutBoundsRect.setX(boundsInParent.getMinX());
        this.layoutBoundsRect.setY(boundsInParent.getMinY());
        this.layoutBoundsRect.setWidth(boundsInParent.getWidth());
        this.layoutBoundsRect.setHeight(boundsInParent.getHeight());
    }
}

