/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateBendpointCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.DeleteBendpointCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.MoveBendpointCommand;
import org.eclipse.gef.requests.BendpointRequest;

public class WireBendpointEditPolicy
extends BendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        CreateBendpointCommand com = new CreateBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setWire((Wire)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        MoveBendpointCommand com = new MoveBendpointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setWire((Wire)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        DeleteBendpointCommand com = new DeleteBendpointCommand();
        Point p = request.getLocation();
        com.setLocation(p);
        com.setWire((Wire)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }
}

