/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractMvcExample
extends Application {
    protected final String title;

    public AbstractMvcExample(String title) {
        this.title = title;
    }

    protected abstract Module createModule();

    public void start(Stage primaryStage) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModule()});
        FXDomain domain = (FXDomain)injector.getInstance(FXDomain.class);
        FXViewer viewer = (FXViewer)domain.getAdapter(IViewer.class);
        primaryStage.setScene(new Scene((Parent)viewer.getScrollPane()));
        primaryStage.setResizable(true);
        primaryStage.setWidth(640.0);
        primaryStage.setHeight(480.0);
        primaryStage.setTitle(this.title);
        primaryStage.sizeToScene();
        primaryStage.show();
        domain.activate();
        ((ContentModel)viewer.getAdapter(ContentModel.class)).setContents(this.createContents());
    }

    protected abstract List<? extends Object> createContents();
}

