/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.tools.ITool;

public abstract class AbstractTool<VR>
implements ITool<VR> {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean active = false;
    private IDomain<VR> domain;

    public void activate() {
        if (this.domain == null) {
            throw new IllegalStateException("The IEditDomain has to be set via setDomain(IDomain) before activation.");
        }
        boolean oldActive = this.active;
        this.active = true;
        if (oldActive != this.active) {
            this.pcs.firePropertyChange("active", oldActive, this.active);
        }
        this.registerListeners();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void deactivate() {
        this.unregisterListeners();
        boolean oldActive = this.active;
        this.active = false;
        if (oldActive != this.active) {
            this.pcs.firePropertyChange("active", oldActive, this.active);
        }
    }

    public IDomain<VR> getAdaptable() {
        return this.domain;
    }

    @Override
    public IDomain<VR> getDomain() {
        return this.getAdaptable();
    }

    public boolean isActive() {
        return this.active;
    }

    protected void registerListeners() {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setAdaptable(IDomain<VR> adaptable) {
        if (this.active) {
            throw new IllegalStateException("The reference to the IDomain may not be changed while the tool is active. Please deactivate the tool before setting the IEditDomain and re-activate it afterwards.");
        }
        this.domain = adaptable;
    }

    protected void unregisterListeners() {
    }
}

