/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;
import org.eclipse.gef4.mvc.policies.ContentPolicy;

public class DeletionPolicy<VR>
extends AbstractPolicy<VR>
implements ITransactional {
    private Set<IContentPart<VR, ? extends VR>> partsToDelete;

    @Override
    public IUndoableOperation commit() {
        ContentPolicy policy;
        ReverseUndoCompositeOperation rev = new ReverseUndoCompositeOperation("Unestablish Anchor Relations");
        for (IContentPart<VR, ? extends VR> iContentPart : this.partsToDelete) {
            policy = (ContentPolicy)iContentPart.getAdapter(ContentPolicy.class);
            if (policy == null) continue;
            policy.init();
            policy.detachAllContentAnchoreds();
            policy.detachFromAllContentAnchorages();
            IUndoableOperation detachOperation = policy.commit();
            if (detachOperation == null) continue;
            rev.add(detachOperation);
        }
        for (IContentPart<VR, ? extends VR> iContentPart : this.partsToDelete) {
            policy = (ContentPolicy)iContentPart.getAdapter(ContentPolicy.class);
            if (policy == null) continue;
            policy.init();
            policy.removeFromParent();
            IUndoableOperation removeOperation = policy.commit();
            if (removeOperation == null) continue;
            rev.add(removeOperation);
        }
        this.partsToDelete = null;
        return rev.unwrap();
    }

    public void delete(Collection<IContentPart<VR, ? extends VR>> contentPartsToDelete) {
        this.partsToDelete.addAll(contentPartsToDelete);
    }

    public void delete(IContentPart<VR, ? extends VR> ... contentPartsToDelete) {
        this.partsToDelete.addAll(Arrays.asList(contentPartsToDelete));
    }

    @Override
    public void init() {
        this.partsToDelete = new HashSet<IContentPart<VR, ? extends VR>>();
    }
}

